/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.Target_java_net_InetAddress_InetAddressHolder;
import com.oracle.svm.core.posix.Target_java_net_NetworkInterface;
import com.oracle.svm.core.posix.Target_os;
import com.oracle.svm.core.posix.Util_java_net_Inet6Address;
import com.oracle.svm.core.posix.Util_java_net_InetAddress;
import com.oracle.svm.core.posix.Util_jni;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.NetinetTcp;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Sysctl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.DarwinSysctl;
import com.oracle.svm.core.util.VMError;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

class JavaNetNetUtilMD {
    @Platforms(value={Platform.LINUX.class})
    static int vinit = 0;
    @Platforms(value={Platform.LINUX.class})
    static int kernelV24 = 0;
    @Platforms(value={Platform.LINUX.class})
    static int vinit24 = 0;
    @Platforms(value={Platform.LINUX.class})
    static int lo_scope_id = 0;
    private static OptEntry[] opts = null;

    private JavaNetNetUtilMD() {
    }

    static void platformInit() {
    }

    static void parseExclusiveBindProperty() {
    }

    static int NET_IPv4MappedToIPv4(CCharPointer caddr) {
        return (caddr.read(12) & 0xFF) << 24 | (caddr.read(13) & 0xFF) << 16 | (caddr.read(14) & 0xFF) << 8 | caddr.read(15) & 0xFF;
    }

    static boolean NET_IsEqual(CCharPointer caddr1, CCharPointer caddr2) {
        for (int i = 0; i < 16; ++i) {
            if (caddr1.read(i) == caddr2.read(i)) continue;
            return false;
        }
        return true;
    }

    static boolean cmpScopeID(int scope, Socket.sockaddr him) {
        NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)((Object)him);
        return him6.sin6_scope_id() == scope;
    }

    static int getScopeID(Socket.sockaddr him) {
        NetinetIn.sockaddr_in6 hext = (NetinetIn.sockaddr_in6)((Object)him);
        return hext.sin6_scope_id();
    }

    static int getInetAddress_addr(InetAddress iaObj) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_InetAddress_InetAddressHolder holder = Util_java_net_InetAddress.from_InetAddress((InetAddress)iaObj).holder;
        return holder.address;
    }

    static boolean IPv6_supported() {
        return true;
    }

    static void NET_ThrowNew(int errorNumber, String msgArg) throws SocketException, InterruptedException {
        String msg = msgArg;
        if (msg == null) {
            msg = "no further information";
        }
        if (errorNumber == Errno.EBADF()) {
            throw new SocketException("socket closed: " + msg);
        }
        if (errorNumber == Errno.EINTR()) {
            throw new InterruptedException(msg);
        }
        Errno.set_errno(errorNumber);
        throw new SocketException(PosixUtils.lastErrorString(msg));
    }

    static int NET_InetAddressToSockaddr(InetAddress iaObj, int port, Socket.sockaddr him, CIntPointer len, boolean v4MappedAddress) throws SocketException {
        int family = JavaNetNetUtil.getInetAddress_family(iaObj);
        if (JavaNetNetUtil.ipv6_available() && (family != Target_java_net_InetAddress.IPv4 || v4MappedAddress != Util_jni.JNI_FALSE())) {
            NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)((Object)him);
            CCharPointer caddr = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
            if (family == Target_java_net_InetAddress.IPv4) {
                LibC.memset(caddr, (SignedWord)WordFactory.zero(), WordFactory.unsigned((int)16));
                int address = JavaNetNetUtilMD.getInetAddress_addr(iaObj);
                if (address != NetinetIn.INADDR_ANY()) {
                    caddr.write(10, (byte)-1);
                    caddr.write(11, (byte)-1);
                    caddr.write(12, (byte)(address >> 24 & 0xFF));
                    caddr.write(13, (byte)(address >> 16 & 0xFF));
                    caddr.write(14, (byte)(address >> 8 & 0xFF));
                    caddr.write(15, (byte)(address & 0xFF));
                }
            } else {
                JavaNetNetUtil.getInet6Address_ipAddress((Inet6Address)iaObj, caddr);
            }
            LibC.memset(him6, (SignedWord)WordFactory.zero(), SizeOf.unsigned(NetinetIn.sockaddr_in6.class));
            him6.set_sin6_port(NetinetIn.htons(port));
            LibC.memcpy(him6.sin6_addr(), (PointerBase)caddr, SizeOf.unsigned(NetinetIn.in6_addr.class));
            him6.set_sin6_family(Socket.AF_INET6());
            len.write(SizeOf.get(NetinetIn.sockaddr_in6.class));
            if (!IsDefined._ALLBSD_SOURCE() || IsDefined.socket_AF_INET6()) {
                // empty if block
            }
            if (IsDefined.__linux__()) {
                if (JavaNetNetUtilMD.IN6_IS_ADDR_LINKLOCAL(him6.sin6_addr())) {
                    int cached_scope_id = 0;
                    int scope_id = 0;
                    boolean ia6_cachedscopeidID = true;
                    cached_scope_id = Util_java_net_Inet6Address.from_Inet6Address((Inet6Address)((Inet6Address)iaObj)).cached_scope_id;
                    if (!CTypeConversion.toBoolean((int)cached_scope_id)) {
                        boolean ia6_scopeidID = true;
                        scope_id = JavaNetNetUtil.getInet6Address_scopeid((Inet6Address)iaObj);
                        if (scope_id != 0) {
                            if (JavaNetNetUtilMD.kernelIsV24() && JavaNetNetUtilMD.needsLoopbackRoute(him6.sin6_addr())) {
                                Util_java_net_Inet6Address.from_Inet6Address((Inet6Address)((Inet6Address)iaObj)).cached_scope_id = cached_scope_id = lo_scope_id;
                            }
                        } else {
                            if (JavaNetNetUtilMD.kernelIsV24()) {
                                cached_scope_id = JavaNetNetUtilMD.getDefaultIPv6Interface(him6.sin6_addr());
                            } else {
                                cached_scope_id = JavaNetNetUtilMD.getLocalScopeID(him6.sin6_addr());
                                if (cached_scope_id == 0) {
                                    cached_scope_id = JavaNetNetUtilMD.getDefaultIPv6Interface(him6.sin6_addr());
                                }
                            }
                            Util_java_net_Inet6Address.from_Inet6Address((Inet6Address)((Inet6Address)iaObj)).cached_scope_id = cached_scope_id;
                        }
                    }
                    NetinetIn.sockaddr_in6 him6_l882 = (NetinetIn.sockaddr_in6)((Object)him);
                    him6_l882.set_sin6_scope_id(cached_scope_id != 0 ? cached_scope_id : scope_id);
                    len.write(SizeOf.get(NetinetIn.sockaddr_in6.class));
                }
            } else if (family != Target_java_net_InetAddress.IPv4) {
                boolean ia6_scopeidID = true;
                him6.set_sin6_scope_id(JavaNetNetUtil.getInet6Address_scopeid((Inet6Address)iaObj));
            }
        } else {
            NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)((Object)him);
            if (family == Target_java_net_InetAddress.IPv6) {
                throw new SocketException("Protocol family unavailable");
            }
            LibC.memset(him4, (SignedWord)WordFactory.zero(), SizeOf.unsigned(NetinetIn.sockaddr_in.class));
            int address = JavaNetNetUtilMD.getInetAddress_addr(iaObj);
            him4.set_sin_port(NetinetIn.htons((short)port));
            him4.sin_addr().set_s_addr(NetinetIn.htonl(address));
            him4.set_sin_family(Socket.AF_INET());
            len.write(SizeOf.get(NetinetIn.sockaddr_in.class));
        }
        return 0;
    }

    static boolean IN6_IS_ADDR_LINKLOCAL(NetinetIn.in6_addr a) {
        return a.s6_addr().read(0) == -2 && a.s6_addr().read(1) == -128;
    }

    @Platforms(value={Platform.LINUX.class})
    static boolean kernelIsV24() {
        if (!CTypeConversion.toBoolean((int)vinit24)) {
            // empty if block
        }
        vinit24 = 1;
        return CTypeConversion.toBoolean((int)kernelV24);
    }

    @Platforms(value={Platform.LINUX.class})
    static boolean needsLoopbackRoute(NetinetIn.in6_addr dest_addr) {
        VMError.unimplemented();
        return Util_jni.JNI_FALSE();
    }

    @Platforms(value={Platform.LINUX.class})
    static void initLoopbackRoutes() {
        VMError.unimplemented();
    }

    @Platforms(value={Platform.LINUX.class})
    static int getLocalScopeID(NetinetIn.in6_addr addr) {
        VMError.unimplemented();
        return 0;
    }

    @Platforms(value={Platform.LINUX.class})
    static int getDefaultIPv6Interface(NetinetIn.in6_addr target_addr) {
        VMError.unimplemented();
        return 0;
    }

    static void setDefaultScopeID(Socket.sockaddr him) {
        NetinetIn.sockaddr_in6 sin6;
        if (Platform.includedIn(Platform.DARWIN.class) && (sin6 = (NetinetIn.sockaddr_in6)((Object)him)).sin6_family() == Socket.AF_INET6() && sin6.sin6_scope_id() == 0) {
            int defaultIndex = Target_java_net_NetworkInterface.defaultIndex;
            sin6.set_sin6_scope_id(defaultIndex);
        }
    }

    static void NET_SetTrafficClass(Socket.sockaddr him, int trafficClass) {
        if (IsDefined.socket_AF_INET6() && him.sa_family() == Socket.AF_INET6()) {
            NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)((Object)him);
            him6.set_sin6_flowinfo(NetinetIn.htonl((trafficClass & 0xFF) << 20));
        }
    }

    static int NET_Timeout(int fd, long timeout) {
        return Target_os.timeout(fd, timeout);
    }

    static int NET_Read(int fd, CCharPointer bufP, int len) {
        return (int)Target_os.restartable_read(fd, bufP, len);
    }

    static int NET_Connect(int fd, Socket.sockaddr him, int len) {
        return VmPrimsJVM.JVM_Connect(fd, him, len);
    }

    static int NET_Accept(int fd, Socket.sockaddr him, CIntPointer len_Pointer) {
        return VmPrimsJVM.JVM_Accept(fd, him, len_Pointer);
    }

    static int NET_Poll(Poll.pollfd fds, int nfds, int timeout) {
        return Poll.poll(fds, nfds, timeout);
    }

    static int NET_Send(int fd, CCharPointer buf, int nBytes, int flags) {
        return VmPrimsJVM.JVM_Send(fd, buf, nBytes, flags);
    }

    static int NET_SendTo(int fd, CCharPointer buf, int n, int flags, Socket.sockaddr addr, int addr_len) {
        return VmPrimsJVM.JVM_SendTo(fd, buf, n, flags, addr, addr_len);
    }

    static int NET_RecvFrom(int fd, CCharPointer buf, int n, int flags, Socket.sockaddr addr, CIntPointer addr_len) {
        return VmPrimsJVM.JVM_RecvFrom(fd, buf, n, flags, addr, addr_len);
    }

    static int NET_GetPortFromSockaddr(Socket.sockaddr him) {
        if (IsDefined.socket_AF_INET6() && him.sa_family() == Socket.AF_INET6()) {
            return NetinetIn.ntohs(((NetinetIn.sockaddr_in6)((Object)him)).sin6_port());
        }
        return NetinetIn.ntohs(((NetinetIn.sockaddr_in)((Object)him)).sin_port());
    }

    static int NET_Dup2(int fd, int fd2) {
        return Unistd.dup2(fd, fd2);
    }

    static int NET_SocketClose(int fd) {
        return VmPrimsJVM.JVM_SocketClose(fd);
    }

    static void NET_AllocSockaddr(Socket.sockaddrPointer him, CIntPointer len) {
        if (IsDefined.socket_AF_INET6() && JavaNetNetUtil.ipv6_available()) {
            Socket.sockaddr him6 = (Socket.sockaddr)LibC.malloc(WordFactory.unsigned((int)SizeOf.get(NetinetIn.sockaddr_in6.class)));
            him.write(him6);
            len.write(SizeOf.get(NetinetIn.sockaddr_in6.class));
        } else {
            Socket.sockaddr him4 = (Socket.sockaddr)LibC.malloc(WordFactory.unsigned((int)SizeOf.get(NetinetIn.sockaddr_in.class)));
            him.write(him4);
            len.write(SizeOf.get(NetinetIn.sockaddr_in.class));
        }
    }

    @Fold
    static int SOCKADDR_LEN() {
        int sizeof_sockaddr_in = SizeOf.get(NetinetIn.sockaddr_in.class);
        int sizeof_sockaddr_in6 = SizeOf.get(NetinetIn.sockaddr_in6.class);
        int sizeof_SOCKADDR = Integer.max(sizeof_sockaddr_in, sizeof_sockaddr_in6);
        return JavaNetNetUtil.ipv6_available() ? sizeof_SOCKADDR : sizeof_sockaddr_in;
    }

    @Fold
    static int MAX_BUFFER_LEN() {
        return 65536;
    }

    static int MAX_HEAP_BUFFER_LEN() {
        return 131072;
    }

    static int NET_MapSocketOption(int cmd, CIntPointer level_Pointer, CIntPointer optname_Pointer) {
        if (opts == null) {
            opts = new OptEntry[]{new OptEntry(1, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_NODELAY()), new OptEntry(4099, Socket.SOL_SOCKET(), Socket.SO_OOBINLINE()), new OptEntry(128, Socket.SOL_SOCKET(), Socket.SO_LINGER()), new OptEntry(4097, Socket.SOL_SOCKET(), Socket.SO_SNDBUF()), new OptEntry(4098, Socket.SOL_SOCKET(), Socket.SO_RCVBUF()), new OptEntry(8, Socket.SOL_SOCKET(), Socket.SO_KEEPALIVE()), new OptEntry(4, Socket.SOL_SOCKET(), Socket.SO_REUSEADDR()), new OptEntry(32, Socket.SOL_SOCKET(), Socket.SO_BROADCAST()), new OptEntry(3, NetinetIn.IPPROTO_IP(), NetinetIn.IP_TOS()), new OptEntry(16, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_IF()), new OptEntry(18, NetinetIn.IPPROTO_IP(), NetinetIn.IP_MULTICAST_LOOP())};
        }
        if (IsDefined.socket_AF_INET6() && JavaNetNetUtil.ipv6_available()) {
            switch (cmd) {
                case 16: 
                case 31: {
                    level_Pointer.write(NetinetIn.IPPROTO_IPV6());
                    optname_Pointer.write(NetinetIn.IPV6_MULTICAST_IF());
                    return 0;
                }
                case 18: {
                    level_Pointer.write(NetinetIn.IPPROTO_IPV6());
                    optname_Pointer.write(NetinetIn.IPV6_MULTICAST_LOOP());
                    return 0;
                }
            }
        }
        for (int i = 0; i < opts.length; ++i) {
            if (cmd != opts[i].cmd) continue;
            level_Pointer.write(opts[i].level);
            optname_Pointer.write(opts[i].optname);
            return 0;
        }
        return -1;
    }

    static int NET_GetSockOpt(int fd, int level, int opt, PointerBase result_Pointer, CIntPointer len_Pointer) {
        int rv;
        if (IsDefined.socket_AF_INET6() && level == NetinetIn.IPPROTO_IP() && opt == NetinetIn.IP_TOS() && JavaNetNetUtil.ipv6_available()) {
            CIntPointer tc = (CIntPointer)result_Pointer;
            tc.write(-1);
            return 0;
        }
        if (IsDefined.__solaris__()) {
            rv = Socket.getsockopt(fd, level, opt, result_Pointer, len_Pointer);
        } else {
            CIntPointer socklen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            socklen_Pointer.write(len_Pointer.read());
            rv = Socket.getsockopt(fd, level, opt, result_Pointer, socklen_Pointer);
            len_Pointer.write(socklen_Pointer.read());
        }
        if (rv < 0) {
            return rv;
        }
        if (IsDefined.__linux__() && level == Socket.SOL_SOCKET() && (opt == Socket.SO_SNDBUF() || opt == Socket.SO_RCVBUF())) {
            int n = ((CIntPointer)result_Pointer).read();
            ((CIntPointer)result_Pointer).write(n /= 2);
        }
        if (IsDefined.MACOSX() && level == Socket.SOL_SOCKET() && opt == Socket.SO_LINGER()) {
            Socket.linger to_cast = (Socket.linger)result_Pointer;
            to_cast.set_l_linger(to_cast.l_linger() & 0xFF);
        }
        return rv;
    }

    static int NET_SetSockOpt(int fd, int level, int opt, WordPointer arg, int len) {
        int IPTOS_TOS_MASK = 30;
        int IPTOS_PREC_MASK = 224;
        CIntPointer mib = null;
        CLongPointer rlen_Pointer = null;
        CIntPointer bufsize = null;
        CIntPointer maxsockbuf_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        int maxsockbuf_size = SizeOf.get(CIntPointer.class);
        if (IsDefined._ALLBSD_SOURCE()) {
            if (IsDefined.sysctl_KIPC_MAXSOCKBUF()) {
                mib = (CIntPointer)StackValue.get((int)3, CIntPointer.class);
                rlen_Pointer = (CLongPointer)StackValue.get(CLongPointer.class);
            }
            bufsize = (CIntPointer)StackValue.get(CIntPointer.class);
            if (IsDefined.__APPLE__()) {
                maxsockbuf_Pointer.write(-1);
                maxsockbuf_size = SizeOf.get(CIntPointer.class);
            } else {
                VMError.unimplemented();
            }
        }
        if (level == NetinetIn.IPPROTO_IP() && opt == NetinetIn.IP_TOS()) {
            CIntPointer iptos = (CIntPointer)StackValue.get(CIntPointer.class);
            if (IsDefined.socket_AF_INET6() && (IsDefined.__solaris__() || IsDefined.MACOSX()) && JavaNetNetUtil.ipv6_available()) {
                return 0;
            }
            if (IsDefined.socket_AF_INET6() && IsDefined.__linux__()) {
                VMError.unimplemented();
            }
            iptos = (CIntPointer)arg;
            iptos.write(iptos.read() & 0xFE);
        }
        if (IsDefined.__solaris__()) {
            VMError.unimplemented();
        }
        if (IsDefined.__linux__() && level == Socket.SOL_SOCKET() && opt == Socket.SO_RCVBUF() && (bufsize = (CIntPointer)arg).read() < 1024) {
            bufsize.write(1024);
        }
        if (IsDefined._ALLBSD_SOURCE() && level == Socket.SOL_SOCKET() && (opt == Socket.SO_SNDBUF() || opt == Socket.SO_RCVBUF())) {
            if (IsDefined.sysctl_KIPC_MAXSOCKBUF()) {
                if (maxsockbuf_Pointer.read() == -1) {
                    mib.write(0, DarwinSysctl.CTL_KERN());
                    mib.write(1, DarwinSysctl.KERN_IPC());
                    mib.write(2, DarwinSysctl.KIPC_MAXSOCKBUF());
                    rlen_Pointer.write((long)maxsockbuf_size);
                    if (Sysctl.sysctl(mib, 3L, (PointerBase)maxsockbuf_Pointer, (WordPointer)rlen_Pointer, WordFactory.nullPointer(), 0L) == -1) {
                        maxsockbuf_Pointer.write(1024);
                    }
                    maxsockbuf_Pointer.write(maxsockbuf_Pointer.read() / 5 * 4);
                }
            } else if (IsDefined.__OpenBSD__()) {
                VMError.unimplemented();
            } else {
                VMError.unimplemented();
            }
            if ((bufsize = (CIntPointer)arg).read() > maxsockbuf_Pointer.read()) {
                bufsize.write(maxsockbuf_Pointer.read());
            }
            if (opt == Socket.SO_RCVBUF() && bufsize.read() < 1024) {
                bufsize.write(1024);
            }
        }
        if (IsDefined._AIX()) {
            VMError.unimplemented();
        }
        return Socket.setsockopt(fd, level, opt, (PointerBase)arg, len);
    }

    static int NET_Bind(int fd, Socket.sockaddr him, int len) {
        NetinetIn.sockaddr_in sa;
        if (IsDefined.__linux__() && him.sa_family() == Socket.AF_INET() && (NetinetIn.htonl((sa = (NetinetIn.sockaddr_in)((Object)him)).sin_addr().s_addr()) & 0x7F0000FF) == 0x7F0000FF) {
            Errno.set_errno(Errno.EADDRNOTAVAIL());
            return -1;
        }
        if (IsDefined.__solaris__() && IsDefined.socket_AF_INET6()) {
            VMError.unimplemented();
        }
        int rv = Socket.bind(fd, him, len);
        if (IsDefined.__solaris__() && IsDefined.socket_AF_INET6()) {
            VMError.unimplemented();
        }
        return rv;
    }

    private static class OptEntry {
        private final int cmd;
        private final int level;
        private final int optname;

        public OptEntry(int cmd, int level, int optname) {
            this.cmd = cmd;
            this.level = level;
            this.optname = optname;
        }
    }
}

