/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.TimeZoneSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.Arrays;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
final class TimeZoneFeature
implements Feature {
    TimeZoneFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        String[] stringArray;
        TimeZone defaultZone = TimeZone.getDefault();
        if (Options.IncludeAllTimeZones.getValue().booleanValue()) {
            stringArray = TimeZone.getAvailableIDs();
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "GMT";
            stringArray2[1] = "UTC";
            stringArray = stringArray2;
            stringArray2[2] = defaultZone.getID();
        }
        String[] supportedZoneIDs = stringArray;
        Map<String, TimeZone> supportedZones = Arrays.stream(supportedZoneIDs).map(TimeZone::getTimeZone).collect(Collectors.toMap(TimeZone::getID, tz -> tz, (tz1, tz2) -> tz1));
        ImageSingletons.add(TimeZoneSupport.class, (Object)new TimeZoneSupport(supportedZones, defaultZone));
    }

    static class Options {
        @Option(help={"When true, all time zones will be pre-initialized in the image."})
        public static final HostedOptionKey<Boolean> IncludeAllTimeZones = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }
}

