/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.util.VMError;
import com.sun.management.OperatingSystemMXBean;
import javax.management.ObjectName;
import sun.management.Util;

final class SubstrateOperatingSystemMXBean
implements OperatingSystemMXBean {
    private static final ObjectName objectName = Util.newObjectName("java.lang:type=OperatingSystem");
    private static final String MSG = "OperatingSystemMXBean methods";

    SubstrateOperatingSystemMXBean() {
    }

    @Override
    public ObjectName getObjectName() {
        return objectName;
    }

    @Override
    public String getName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getArch() {
        return SubstrateUtil.getArchitectureName();
    }

    @Override
    public String getVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return PhysicalMemory.size().rawValue();
    }

    @Override
    public double getSystemLoadAverage() {
        return -1.0;
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getTotalSwapSpaceSize() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getFreeSwapSpaceSize() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getProcessCpuTime() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getFreePhysicalMemorySize() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public double getSystemCpuLoad() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public double getProcessCpuLoad() {
        throw VMError.unsupportedFeature(MSG);
    }
}

