/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.URLProtocolsSupport;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JavaNetSubstitutions {
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    static final List<String> defaultProtocols = Collections.singletonList("file");
    static final List<String> onDemandProtocols = Arrays.asList("http", "https");
    static final String enableProtocolsOption = SubstrateOptionsParser.commandArgument(SubstrateOptions.EnableURLProtocols, "");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static boolean addURLStreamHandler(String protocol) {
        try {
            Method method = URL.class.getDeclaredMethod("getURLStreamHandler", String.class);
            method.setAccessible(true);
            URLStreamHandler handler = (URLStreamHandler)method.invoke(null, protocol);
            if (handler != null) {
                URLProtocolsSupport.put(protocol, handler);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new Error(ex);
        }
    }

    static URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler result = URLProtocolsSupport.get(protocol);
        if (result == null) {
            if (onDemandProtocols.contains(protocol)) {
                JavaNetSubstitutions.unsupported("Accessing an URL protocol that was not enabled. The URL protocol " + protocol + " is supported but not enabled by default. It must be enabled by adding the " + enableProtocolsOption + protocol + " option to the native-image command.");
            } else {
                JavaNetSubstitutions.unsupported("Accessing an URL protocol that was not enabled. The URL protocol " + protocol + " is not tested and might not work as expected. It can be enabled by adding the " + enableProtocolsOption + protocol + " option to the native-image command.");
            }
        }
        return result;
    }

    private static void unsupported(String message) {
        throw VMError.unsupportedFeature(message);
    }

    static String supportedProtocols() {
        return "Supported URL protocols enabled by default: " + String.join((CharSequence)",", defaultProtocols) + ". Supported URL protocols available on demand: " + String.join((CharSequence)",", onDemandProtocols) + ".";
    }
}

