/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JavaNetSubstitutions;
import com.oracle.svm.core.jdk.URLProtocolsSupport;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
class JavaNetFeature
implements Feature {
    JavaNetFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(URLProtocolsSupport.class, (Object)new URLProtocolsSupport());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        String[] protocols;
        JavaNetSubstitutions.defaultProtocols.forEach(protocol -> {
            boolean registered = JavaNetSubstitutions.addURLStreamHandler(protocol);
            VMError.guarantee(registered, "The URL protocol " + protocol + " is not available.");
        });
        String optionValue = SubstrateOptions.EnableURLProtocols.getValue();
        if (optionValue.isEmpty()) {
            return;
        }
        for (String protocol2 : protocols = optionValue.split(",")) {
            boolean registered;
            if (JavaNetSubstitutions.defaultProtocols.contains(protocol2)) {
                JavaNetFeature.printWarning("The URL protocol " + protocol2 + " is enabled by default. The option " + JavaNetSubstitutions.enableProtocolsOption + protocol2 + " is not needed.");
                continue;
            }
            if (JavaNetSubstitutions.onDemandProtocols.contains(protocol2)) {
                registered = JavaNetSubstitutions.addURLStreamHandler(protocol2);
                VMError.guarantee(registered, "The URL protocol " + protocol2 + " is not available.");
                continue;
            }
            JavaNetFeature.printWarning("The URL protocol " + protocol2 + " is not tested and might not work as expected." + System.lineSeparator() + JavaNetSubstitutions.supportedProtocols());
            registered = JavaNetSubstitutions.addURLStreamHandler(protocol2);
            if (registered) continue;
            JavaNetFeature.printWarning("Registering the " + protocol2 + " URL protocol failed. It will not be available at runtime." + System.lineSeparator());
        }
    }

    private static void printWarning(String warningMessage) {
        System.out.println(warningMessage);
    }
}

