/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.Value;

public class SubstrateReferenceMap
extends ReferenceMap
implements ReferenceMapEncoder.Input {
    private final BitSet input = new BitSet();
    private Map<Integer, Object> debugAllUsedRegisters;
    private Map<Integer, Object> debugAllUsedStackSlots;

    public SubstrateReferenceMap() {
        assert (ConfigurationValues.getObjectLayout().getReferenceSize() > 2) : "needs to be three bits or more for encoding and validation";
    }

    public boolean isOffsetMarked(int offset) {
        return this.input.get(offset);
    }

    public boolean isOffsetCompressed(int offset) {
        assert (this.isOffsetMarked(offset));
        return this.input.get(offset + 1);
    }

    public void markReferenceAtOffset(int offset, boolean compressed) {
        assert (this.isValidToMark(offset, compressed)) : "already marked or would overlap with predecessor or successor";
        this.input.set(offset);
        if (compressed) {
            this.input.set(offset + 1);
        }
    }

    private boolean isValidToMark(int offset, boolean isCompressed) {
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int previousOffset = this.input.previousSetBit(offset - 1);
        if (previousOffset != -1) {
            int minOffset = previousOffset + uncompressedSize;
            if (previousOffset != 0 && this.input.get(previousOffset - 1)) {
                minOffset = --previousOffset + compressedSize;
            }
            if (offset < minOffset) {
                return false;
            }
        }
        int size = isCompressed ? compressedSize : uncompressedSize;
        int nextIndex = this.input.nextSetBit(offset);
        return nextIndex == -1 || offset + size <= nextIndex;
    }

    public Map<Integer, Object> getDebugAllUsedRegisters() {
        return this.debugAllUsedRegisters;
    }

    boolean debugMarkRegister(int offset, Value value) {
        if (this.debugAllUsedRegisters == null) {
            this.debugAllUsedRegisters = new HashMap<Integer, Object>();
        }
        this.debugAllUsedRegisters.put(offset, value);
        return true;
    }

    public Map<Integer, Object> getDebugAllUsedStackSlots() {
        return this.debugAllUsedStackSlots;
    }

    boolean debugMarkStackSlot(int offset, StackSlot value) {
        if (this.debugAllUsedStackSlots == null) {
            this.debugAllUsedStackSlots = new HashMap<Integer, Object>();
        }
        this.debugAllUsedStackSlots.put(offset, value);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.input.isEmpty();
    }

    @Override
    public ReferenceMapEncoder.OffsetIterator getOffsets() {
        return new ReferenceMapEncoder.OffsetIterator(){
            private int nextIndex;
            {
                this.nextIndex = SubstrateReferenceMap.this.input.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex != -1;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int index = this.nextIndex;
                this.nextIndex = SubstrateReferenceMap.this.input.nextSetBit(index + 2);
                return index;
            }

            @Override
            public boolean isNextCompressed() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SubstrateReferenceMap.this.isOffsetCompressed(this.nextIndex);
            }
        };
    }

    public int hashCode() {
        return this.input.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubstrateReferenceMap) {
            SubstrateReferenceMap other = (SubstrateReferenceMap)obj;
            return this.input.equals(other.input);
        }
        return false;
    }
}

