/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.heap.DiscoverableReference;
import com.oracle.svm.core.heap.FeebleReferenceList;

@UnknownClass
public class FeebleReference<T>
extends DiscoverableReference {
    private FeebleReferenceList<T> list;
    private FeebleReference<? extends T> next;

    public static <T> FeebleReference<T> factory(T referent, FeebleReferenceList<T> list) {
        return new FeebleReference<T>(referent, list);
    }

    public T get() {
        return (T)this.getReferentObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    boolean isEnlisted() {
        return this.next != this;
    }

    public FeebleReferenceList<T> getList() {
        return this.list;
    }

    public void clearList() {
        this.list = null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    FeebleReference<? extends T> listGetNext() {
        return this.isEnlisted() ? this.next : null;
    }

    void listPrepend(FeebleReference<?> value) {
        assert (value != this);
        assert (!this.isEnlisted());
        this.next = value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    void listRemove() {
        this.next = this;
    }

    protected FeebleReference(T referent, FeebleReferenceList<T> list) {
        super(referent);
        this.list = list;
        FeebleReferenceList.clean(this);
    }
}

