/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class AddressOfVMThreadLocalNode
extends FloatingNode
implements Lowerable {
    public static final NodeClass<AddressOfVMThreadLocalNode> TYPE = NodeClass.create(AddressOfVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    @Node.Input
    protected ValueNode holder;

    public AddressOfVMThreadLocalNode(VMThreadLocalInfo threadLocalInfo, ValueNode holder) {
        super(TYPE, FrameAccess.getWordStamp());
        this.threadLocalInfo = threadLocalInfo;
        this.holder = holder;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0L);
        ValueNode base = this.holder;
        if (base.getStackKind() == JavaKind.Object) {
            base = (ValueNode)this.graph().unique((Node)new FloatingWordCastNode(FrameAccess.getWordStamp(), base));
        }
        assert (base.getStackKind() == FrameAccess.getWordKind());
        ConstantNode offset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)this.threadLocalInfo.offset, (StructuredGraph)this.graph());
        ValueNode address = (ValueNode)this.graph().unique((Node)new AddNode(base, (ValueNode)offset));
        this.replaceAtUsagesAndDelete((Node)address);
    }
}

