/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.PointerBase;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class WriteHeapBaseNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<WriteHeapBaseNode> TYPE = NodeClass.create(WriteHeapBaseNode.class);
    @Node.Input
    protected ValueNode value;

    protected WriteHeapBaseNode(ValueNode value) {
        super(TYPE, StampFactory.forVoid());
        this.value = value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        tool.emitMove((AllocatableValue)((SubstrateRegisterConfig)tool.getResult().getRegisterConfig()).getHeapBaseRegister().asValue((ValueKind)tool.getLIRKind(FrameAccess.getWordStamp())), gen.operand((Node)this.value));
    }

    @Node.NodeIntrinsic
    public static native void writeCurrentVMHeapBase(PointerBase var0);
}

