/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.amd64.FrameAccess;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ReadStackPointerNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<ReadStackPointerNode> TYPE = NodeClass.create(ReadStackPointerNode.class);

    public ReadStackPointerNode() {
        super(TYPE, FrameAccess.getWordStamp());
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        RegisterValue input = tool.getRegisterConfig().getFrameRegister().asValue((ValueKind)tool.getLIRKind(FrameAccess.getWordStamp()));
        gen.setResult((ValueNode)this, (Value)tool.emitMove((Value)input));
    }
}

