/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.amd64.FrameAccess;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ReadReturnAddressNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<ReadReturnAddressNode> TYPE = NodeClass.create(ReadReturnAddressNode.class);

    public ReadReturnAddressNode() {
        super(TYPE, FrameAccess.getWordStamp());
    }

    public void generate(NodeLIRBuilderTool gen) {
        assert (FrameAccess.returnAddressSize() > 0);
        Variable result = gen.getLIRGeneratorTool().emitMove((Value)StackSlot.get((ValueKind)gen.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (int)(-FrameAccess.returnAddressSize()), (boolean)true));
        gen.setResult((ValueNode)this, (Value)result);
    }
}

