/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.function.Function;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ReadRegisterFloatingNode
extends FloatingNode
implements LIRLowerable {
    public static final NodeClass<ReadRegisterFloatingNode> TYPE = NodeClass.create(ReadRegisterFloatingNode.class);
    private final Function<SubstrateRegisterConfig, Register> registerSupplier;

    public static ReadRegisterFloatingNode forHeapBase() {
        return new ReadRegisterFloatingNode(SubstrateRegisterConfig::getHeapBaseRegister);
    }

    public static ReadRegisterFloatingNode forIsolateThread() {
        return new ReadRegisterFloatingNode(SubstrateRegisterConfig::getThreadRegister);
    }

    public ReadRegisterFloatingNode(Function<SubstrateRegisterConfig, Register> registerSupplier) {
        super(TYPE, FrameAccess.getWordStamp());
        this.registerSupplier = registerSupplier;
    }

    public void generate(NodeLIRBuilderTool gen) {
        VMError.guarantee(this.usages().filter(FrameState.class).isEmpty(), "When used in a FrameState, need a ReadRegisterFixedNode and not a ReadRegisterFloatingNode");
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        SubstrateRegisterConfig registerConfig = (SubstrateRegisterConfig)tool.getRegisterConfig();
        LIRKind lirKind = tool.getLIRKind(FrameAccess.getWordStamp());
        RegisterValue value = this.registerSupplier.apply(registerConfig).asValue((ValueKind)lirKind);
        gen.setResult((ValueNode)this, (Value)value);
    }
}

