/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;

@NodeInfo(size=NodeSize.SIZE_IGNORED, cycles=NodeCycles.CYCLES_IGNORED)
public final class NullaryConstructorOffsetNode
extends FloatingNode
implements Canonicalizable {
    public static final NodeClass<NullaryConstructorOffsetNode> TYPE = NodeClass.create(NullaryConstructorOffsetNode.class);
    public static final int NULLARY_CONSTRUCTOR_OFFSET = 0;
    private final RuntimeConfiguration runtimeConfig;

    public NullaryConstructorOffsetNode(RuntimeConfiguration runtimeConfig) {
        super(TYPE, FrameAccess.getWordStamp());
        this.runtimeConfig = runtimeConfig;
    }

    public Node canonical(CanonicalizerTool tool) {
        if (this.runtimeConfig.isFullyInitialized()) {
            int vtableEntryOffset = this.runtimeConfig.getVTableOffset(0);
            return ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)vtableEntryOffset);
        }
        return this;
    }
}

