/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.code.amd64.AMD64CGlobalDataLoadAddressOp;
import com.oracle.svm.core.graal.code.amd64.AMD64DecrementingSafepointCheckOp;
import com.oracle.svm.core.graal.code.amd64.AMD64FarReturnOp;
import com.oracle.svm.core.graal.code.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.code.amd64.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.amd64.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMapBuilder;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.util.VMError;
import java.util.Collection;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRKindTool;
import org.graalvm.compiler.core.amd64.AMD64MoveFactory;
import org.graalvm.compiler.core.amd64.AMD64MoveFactoryBase;
import org.graalvm.compiler.core.amd64.AMD64NodeLIRBuilder;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64BreakpointOp;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.amd64.AMD64ControlFlow;
import org.graalvm.compiler.lir.amd64.AMD64FrameMap;
import org.graalvm.compiler.lir.amd64.AMD64FrameMapBuilder;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64PrefetchOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateAMD64Backend
extends Backend {
    public static final String MARK_PROLOGUE_DECD_RSP = "PROLOGUE_DECD_RSP";
    public static final String MARK_PROLOGUE_SAVED_REGS = "PROLOGUE_SAVED_REGS";
    public static final String MARK_PROLOGUE_END = "PROLOGUE_END";
    public static final String MARK_EPILOGUE_START = "EPILOGUE_START";
    public static final String MARK_EPILOGUE_INCD_RSP = "EPILOGUE_INCD_RSP";
    public static final String MARK_EPILOGUE_END = "EPILOGUE_END";

    protected static CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    public SubstrateAMD64Backend(Providers providers) {
        super(providers);
    }

    public FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AMD64FrameMapBuilder(this.newFrameMap(registerConfigNonNull), this.getCodeCache(), registerConfigNonNull);
    }

    public FrameMap newFrameMap(RegisterConfig registerConfig) {
        return new AMD64FrameMap(this.getProviders().getCodeCache(), registerConfig, (FrameMap.ReferenceMapBuilderFactory)new SubstrateReferenceMapBuilderFactory());
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, StructuredGraph graph, Object stub) {
        SharedMethod method = (SharedMethod)graph.method();
        CallingConvention callingConvention = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)(method.isEntryPoint() ? SubstrateCallingConventionType.NativeCallee : SubstrateCallingConventionType.JavaCallee), (ResolvedJavaMethod)method, (ValueKindFactory)this);
        return new SubstrateLIRGenerationResult(compilationId, lir, frameMapBuilder, callingConvention, method);
    }

    protected AMD64ArithmeticLIRGenerator createArithmeticLIRGen(RegisterValue nullRegisterValue) {
        return new AMD64ArithmeticLIRGenerator((AllocatableValue)nullRegisterValue, null);
    }

    protected static SubstrateAMD64RegisterConfig getRegisterConfig(LIRGenerationResult lirGenRes) {
        return (SubstrateAMD64RegisterConfig)lirGenRes.getRegisterConfig();
    }

    private static Register getHeapBaseRegister(LIRGenerationResult lirGenRes) {
        return SubstrateAMD64Backend.getRegisterConfig(lirGenRes).getHeapBaseRegister();
    }

    protected AMD64MoveFactoryBase createMoveFactory(LIRGenerationResult lirGenRes, AMD64MoveFactoryBase.BackupSlotProvider backupSlotProvider) {
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenRes).getMethod();
        return new SubstrateAMD64MoveFactory(backupSlotProvider, method, this.createLirKindTool(), SubstrateAMD64Backend.getRegisterConfig(lirGenRes));
    }

    protected LIRKindTool createLirKindTool() {
        return new SubstrateAMD64LIRKindTool();
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        RegisterValue nullRegisterValue = SubstrateAMD64Backend.useLinearPointerCompression() ? SubstrateAMD64Backend.getHeapBaseRegister(lirGenRes).asValue() : null;
        AMD64ArithmeticLIRGenerator arithmeticLIRGen = this.createArithmeticLIRGen(nullRegisterValue);
        AMD64MoveFactoryBase.BackupSlotProvider backupSlotProvider = new AMD64MoveFactoryBase.BackupSlotProvider(lirGenRes.getFrameMapBuilder());
        AMD64MoveFactoryBase moveFactory = this.createMoveFactory(lirGenRes, backupSlotProvider);
        return new SubstrateAMD64LIRGenerator(this.createLirKindTool(), arithmeticLIRGen, (LIRGeneratorTool.MoveFactory)moveFactory, this.getProviders(), lirGenRes);
    }

    protected AMD64NodeMatchRules createMatchRules(LIRGeneratorTool lirGen) {
        return new AMD64NodeMatchRules(lirGen);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        AMD64NodeMatchRules nodeMatchRules = this.createMatchRules(lirGen);
        return new SubstrateAMD64NodeLIRBuilder(graph, lirGen, nodeMatchRules);
    }

    private static boolean useLinearPointerCompression() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenResult, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        Assembler masm = this.createAssembler(frameMap);
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenResult).getMethod();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        SubstrateAMD64FrameContext frameContext = stubType == Deoptimizer.StubType.EntryStub ? new DeoptEntryStubContext() : (stubType == Deoptimizer.StubType.ExitStub ? new DeoptExitStubContext() : new SubstrateAMD64FrameContext());
        LIR lir = lirGenResult.getLIR();
        OptionValues options = lir.getOptions();
        DebugContext debug = lir.getDebug();
        Register nullRegister = SubstrateAMD64Backend.useLinearPointerCompression() ? SubstrateAMD64Backend.getHeapBaseRegister(lirGenResult) : Register.None;
        CompilationResultBuilder tasm = factory.createBuilder(this.getCodeCache(), this.getForeignCalls(), lirGenResult.getFrameMap(), masm, (DataBuilder)dataBuilder, (FrameContext)frameContext, options, debug, compilationResult, nullRegister);
        tasm.setTotalFrameSize(lirGenResult.getFrameMap().totalFrameSize());
        return tasm;
    }

    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new RegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    protected Assembler createAssembler(FrameMap frameMap) {
        return new AMD64MacroAssembler(this.getTarget());
    }

    public CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult) {
        return new SubstrateCompiledCode(compilationResult);
    }

    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner) {
        crb.emit(lir);
    }

    public SuitesProvider getSuites() {
        throw VMError.unimplemented();
    }

    public static int getDeoptScratchSpace() {
        return 16;
    }

    public EconomicSet<Register> translateToCallerRegisters(EconomicSet<Register> calleeRegisters) {
        return calleeRegisters;
    }

    protected static class SubstrateAMD64LIRKindTool
    extends AMD64LIRKindTool {
        protected SubstrateAMD64LIRKindTool() {
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)AMD64Kind.QWORD);
        }

        public LIRKind getNarrowPointerKind() {
            throw VMError.shouldNotReachHere();
        }
    }

    protected static class SubstrateAMD64MoveFactory
    extends AMD64MoveFactory {
        private final SharedMethod method;
        private final LIRKindTool lirKindTool;
        private final SubstrateAMD64RegisterConfig registerConfig;

        protected SubstrateAMD64MoveFactory(AMD64MoveFactoryBase.BackupSlotProvider backupSlotProvider, SharedMethod method, LIRKindTool lirKindTool, SubstrateAMD64RegisterConfig registerConfig) {
            super(backupSlotProvider);
            this.method = method;
            this.lirKindTool = lirKindTool;
            this.registerConfig = registerConfig;
        }

        public boolean allowConstantToStackMove(Constant constant) {
            if (constant instanceof SubstrateObjectConstant && this.method.isDeoptTarget()) {
                return false;
            }
            return super.allowConstantToStackMove(constant);
        }

        public AMD64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createLoad(dst, (Constant)JavaConstant.INT_0);
            }
            if (src instanceof SubstrateObjectConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            return super.createLoad(dst, src);
        }

        public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals(src)) {
                return super.createStackLoad(dst, (Constant)JavaConstant.INT_0);
            }
            if (src instanceof SubstrateObjectConstant) {
                return this.loadObjectConstant(dst, (SubstrateObjectConstant)src);
            }
            return super.createStackLoad(dst, src);
        }

        protected AMD64LIRInstruction loadObjectConstant(AllocatableValue dst, SubstrateObjectConstant constant) {
            if (ReferenceAccess.singleton().haveCompressedReferences()) {
                RegisterValue heapBase = this.registerConfig.getHeapBaseRegister().asValue();
                return new LoadCompressedObjectConstantOp(dst, constant, (AllocatableValue)heapBase, SubstrateAMD64Backend.getCompressEncoding(), this.lirKindTool);
            }
            return new AMD64Move.MoveFromConstOp(dst, (JavaConstant)constant);
        }

        public static final class LoadCompressedObjectConstantOp
        extends AMD64Move.PointerCompressionOp
        implements StandardOp.LoadConstantOp {
            public static final LIRInstructionClass<LoadCompressedObjectConstantOp> TYPE = LIRInstructionClass.create(LoadCompressedObjectConstantOp.class);
            private final SubstrateObjectConstant constant;

            static JavaConstant asCompressed(SubstrateObjectConstant constant) {
                return constant.isCompressed() ? constant : constant.compress();
            }

            LoadCompressedObjectConstantOp(AllocatableValue result, SubstrateObjectConstant constant, AllocatableValue baseRegister, CompressEncoding encoding, LIRKindTool lirKindTool) {
                super(TYPE, result, (Value)new ConstantValue((ValueKind)lirKindTool.getNarrowOopKind(), (Constant)LoadCompressedObjectConstantOp.asCompressed(constant)), baseRegister, encoding, true, lirKindTool);
                this.constant = constant;
            }

            public Constant getConstant() {
                return this.constant;
            }

            public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
                Register resultReg = this.getResultRegister();
                int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
                Constant inputConstant = LIRValueUtil.asConstantValue((Value)this.getInput()).getConstant();
                if (masm.target.inlineObjects) {
                    crb.recordInlineDataInCode(inputConstant);
                    masm.movq(resultReg, -2401018187971961171L, true);
                } else {
                    AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(inputConstant, referenceSize);
                    masm.movq(resultReg, address);
                }
                if (!this.constant.isCompressed()) {
                    Register baseReg = this.getBaseRegister(crb);
                    assert (!baseReg.equals((Object)Register.None) || this.getShift() != 0) : "no compression in place";
                    masm.leaq(resultReg, new AMD64Address(baseReg, resultReg, AMD64Address.Scale.fromShift((int)this.getShift())));
                }
            }
        }
    }

    static class SubstrateReferenceMapBuilderFactory
    implements FrameMap.ReferenceMapBuilderFactory {
        SubstrateReferenceMapBuilderFactory() {
        }

        public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
            return new SubstrateReferenceMapBuilder(totalFrameSize);
        }
    }

    protected static class DeoptExitStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptExitStubContext() {
        }

        @Override
        public void leave(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            assert (SubstrateAMD64Backend.getDeoptScratchSpace() >= 16);
            super.leave(tasm);
            int scratchOffset = DeoptimizedFrame.getScratchSpaceOffset();
            asm.movq(AMD64.xmm0, new AMD64Address(AMD64.rax, scratchOffset + 8));
            asm.movq(AMD64.rax, new AMD64Address(AMD64.rax, scratchOffset));
        }
    }

    protected static class DeoptEntryStubContext
    extends SubstrateAMD64FrameContext {
        protected DeoptEntryStubContext() {
        }

        @Override
        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            assert (SubstrateAMD64Backend.getDeoptScratchSpace() >= 16);
            asm.movq(AMD64.rdi, new AMD64Address(AMD64.rsp, 0));
            int scratchOffset = DeoptimizedFrame.getScratchSpaceOffset();
            asm.movq(new AMD64Address(AMD64.rdi, scratchOffset), AMD64.rax);
            asm.movq(new AMD64Address(AMD64.rdi, scratchOffset + 8), AMD64.xmm0);
            super.enter(tasm);
        }
    }

    protected static class SubstrateAMD64FrameContext
    implements FrameContext {
        protected SubstrateAMD64FrameContext() {
        }

        public void enter(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            int frameSize = tasm.frameMap.frameSize();
            asm.decrementq(AMD64.rsp, frameSize);
            tasm.recordMark((Object)SubstrateAMD64Backend.MARK_PROLOGUE_DECD_RSP);
            tasm.recordMark((Object)SubstrateAMD64Backend.MARK_PROLOGUE_END);
        }

        public void leave(CompilationResultBuilder tasm) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)tasm.asm;
            int frameSize = tasm.frameMap.frameSize();
            tasm.recordMark((Object)SubstrateAMD64Backend.MARK_EPILOGUE_START);
            asm.incrementq(AMD64.rsp, frameSize);
            if (frameSize != 0) {
                tasm.recordMark((Object)SubstrateAMD64Backend.MARK_EPILOGUE_INCD_RSP);
            }
            tasm.recordMark((Object)SubstrateAMD64Backend.MARK_EPILOGUE_END);
        }

        public boolean hasFrame() {
            return true;
        }
    }

    public static final class SubstrateAMD64NodeLIRBuilder
    extends AMD64NodeLIRBuilder
    implements SubstrateNodeLIRBuilder {
        public SubstrateAMD64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
            super(graph, gen, nodeMatchRules);
        }

        public void visitSafepointNode(SafepointNode node) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void visitBreakpointNode(BreakpointNode node) {
            JavaType[] sig = new JavaType[node.arguments().size()];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
            }
            CallingConvention convention = this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionType.JavaCall, null, sig, (ValueKindFactory)this.gen);
            this.append((LIRInstruction)new AMD64BreakpointOp(this.visitInvokeArguments(convention, (Collection<ValueNode>)node.arguments())));
        }

        protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
            return new SubstrateDebugInfoBuilder(nodeValueMap, graph.getDebug());
        }

        public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
            Value[] values = super.visitInvokeArguments(invokeCc, arguments);
            SubstrateCallingConventionType type = (SubstrateCallingConventionType)((SubstrateCallingConvention)invokeCc).getType();
            if (type.nativeABI) {
                int xmmCount = 0;
                for (Value v : values) {
                    if (!ValueUtil.isRegister((Value)v) || !ValueUtil.asRegister((Value)v).getRegisterCategory().equals((Object)AMD64.XMM)) continue;
                    ++xmmCount;
                }
                assert (xmmCount <= 8);
                RegisterValue xmmCountRegister = AMD64.rax.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.DWORD));
                this.gen.emitMoveConstant((AllocatableValue)xmmCountRegister, (Constant)JavaConstant.forInt((int)xmmCount));
            }
            return values;
        }

        protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, parameters, temps, callState));
        }

        protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            Register targetRegister = AMD64.rax;
            if (((SubstrateCallingConventionType)callTarget.callType()).nativeABI) {
                targetRegister = AMD64.r10;
            }
            RegisterValue targetAddress = targetRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)targetAddress, this.operand((Node)callTarget.computedAddress()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new AMD64Call.IndirectCallOp(targetMethod, result, parameters, temps, (Value)targetAddress, callState));
        }

        public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
            if (node instanceof SafepointCheckNode) {
                this.append((LIRInstruction)new AMD64DecrementingSafepointCheckOp());
                this.append((LIRInstruction)new AMD64ControlFlow.BranchOp(AMD64Assembler.ConditionFlag.Zero, trueSuccessor, falseSuccessor, trueSuccessorProbability));
            } else {
                super.emitBranch(node, trueSuccessor, falseSuccessor, trueSuccessorProbability);
            }
        }

        @Override
        public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
            Variable result = this.gen.newVariable((ValueKind)this.gen.getLIRKindTool().getWordKind());
            this.append((LIRInstruction)new AMD64CGlobalDataLoadAddressOp(node.getDataInfo(), (AllocatableValue)result));
            this.setResult((ValueNode)node, (Value)result);
        }
    }

    public static final class SubstrateDebugInfoBuilder
    extends DebugInfoBuilder {
        public SubstrateDebugInfoBuilder(NodeValueMap nodeValueMap, DebugContext debug) {
            super(nodeValueMap, debug);
        }

        protected JavaKind storageKind(JavaType type) {
            return ((SharedType)type).getStorageKind();
        }
    }

    protected final class SubstrateAMD64LIRGenerator
    extends AMD64LIRGenerator
    implements SubstrateLIRGenerator {
        public SubstrateAMD64LIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, LIRGeneratorTool.MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
        }

        public SubstrateLIRGenerationResult getResult() {
            return (SubstrateLIRGenerationResult)super.getResult();
        }

        public SubstrateRegisterConfig getRegisterConfig() {
            return (SubstrateRegisterConfig)super.getRegisterConfig();
        }

        private Register getHeapBaseRegister() {
            return this.getRegisterConfig().getHeapBaseRegister();
        }

        protected void emitForeignCallOp(ForeignCallLinkage linkage, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            ResolvedJavaMethod targetMethod = callTarget.getMethod();
            this.append((LIRInstruction)new SubstrateAMD64DirectCallOp(targetMethod, result, arguments, temps, info));
        }

        public void emitUnwind(Value operand) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
            throw VMError.shouldNotReachHere("Substrate VM does not use deoptimization");
        }

        public void emitCCall(long address, CallingConvention nativeCallingConvention, Value[] args, int numberOfFloatingPointArguments) {
            throw VMError.unimplemented();
        }

        @Override
        public Value emitReadInstructionPointer() {
            return this.emitMove((Value)new AMD64AddressValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRKindTool()), (AllocatableValue)AMD64.rip.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRKindTool())), 0));
        }

        @Override
        public void emitFarReturn(AllocatableValue result, Value sp, Value ip) {
            this.append((LIRInstruction)new AMD64FarReturnOp(result, this.asAllocatable(sp), this.asAllocatable(ip)));
        }

        @Override
        public void emitDeadEnd() {
            this.append(new DeadEndOp());
        }

        public void emitPrefetchAllocate(Value address) {
            this.append((LIRInstruction)new AMD64PrefetchOp(this.asAddressValue(address), SubstrateOptions.AllocatePrefetchInstr.getValue().intValue()));
        }

        public Value emitCompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getNarrowOopKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.CompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)this.getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            assert (((LIRKind)pointer.getValueKind(LIRKind.class)).getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind());
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getObjectKind());
            boolean nonNull = SubstrateAMD64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AMD64Move.UncompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)this.getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public void emitConvertNullToZero(AllocatableValue result, Value value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertNullToZeroOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public void emitConvertZeroToNull(AllocatableValue result, Value value) {
            if (SubstrateAMD64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AMD64Move.ConvertZeroToNullOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }
    }

    protected static final class SubstrateLIRGenerationResult
    extends LIRGenerationResult {
        private final SharedMethod method;

        public SubstrateLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, CallingConvention callingConvention, SharedMethod method) {
            super(compilationId, lir, frameMapBuilder, callingConvention);
            this.method = method;
            if (method.canDeoptimize() || method.isDeoptTarget()) {
                ((FrameMapBuilderTool)frameMapBuilder).getFrameMap().reserveOutgoing(16);
            }
        }

        public SharedMethod getMethod() {
            return this.method;
        }
    }

    @Opcode(value="DEAD_END")
    public static class DeadEndOp
    extends LIRInstruction
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<DeadEndOp> TYPE = LIRInstructionClass.create(DeadEndOp.class);

        public DeadEndOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb) {
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class SubstrateAMD64DirectCallOp
    extends AMD64Call.DirectCallOp {
        public static final LIRInstructionClass<SubstrateAMD64DirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAMD64DirectCallOp.class);

        public SubstrateAMD64DirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, callTarget, result, parameters, temps, state);
        }

        public void emitCode(CompilationResultBuilder tasm, AMD64MacroAssembler masm) {
            AMD64Call.directCall((CompilationResultBuilder)tasm, (AMD64MacroAssembler)masm, (InvokeTarget)this.callTarget, null, (boolean)false, (LIRFrameState)this.state);
        }
    }
}

