/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.graal.PostWriteBarrierNode;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class InsertWriteBarrierPhase
extends BasePhase<MidTierContext> {
    public static InsertWriteBarrierPhase factory() {
        return new InsertWriteBarrierPhase();
    }

    public boolean checkContract() {
        return false;
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        for (Node n : graph.getNodes()) {
            if (n instanceof WriteNode) {
                this.rewriteWithBarriers(graph, (WriteNode)n);
            }
            if (n instanceof AbstractCompareAndSwapNode) {
                this.rewriteWithBarriers(graph, (AbstractCompareAndSwapNode)n);
            }
            if (!(n instanceof LoweredAtomicReadAndWriteNode)) continue;
            this.rewriteWithBarriers(graph, (LoweredAtomicReadAndWriteNode)n);
        }
    }

    protected void rewriteWithBarriers(StructuredGraph graph, WriteNode node) {
        if (node.getBarrierType() == HeapAccess.BarrierType.NONE) {
            return;
        }
        ValueNode value = node.value();
        if (!value.getStackKind().isObject()) {
            return;
        }
        if (StampTool.isPointerAlwaysNull((ValueNode)value)) {
            return;
        }
        this.addPostWriteBarrier(graph, (FixedAccessNode)node, node.getAddress());
    }

    protected void rewriteWithBarriers(StructuredGraph graph, AbstractCompareAndSwapNode node) {
        if (node.getBarrierType() == HeapAccess.BarrierType.NONE) {
            return;
        }
        ValueNode value = node.getNewValue();
        if (!value.getStackKind().isObject()) {
            return;
        }
        if (StampTool.isPointerAlwaysNull((ValueNode)value)) {
            return;
        }
        this.addPostWriteBarrier(graph, (FixedAccessNode)node, node.getAddress());
    }

    protected void rewriteWithBarriers(StructuredGraph graph, LoweredAtomicReadAndWriteNode node) {
        if (node.getBarrierType() == HeapAccess.BarrierType.NONE) {
            return;
        }
        ValueNode value = node.getNewValue();
        if (!value.getStackKind().isObject()) {
            return;
        }
        if (StampTool.isPointerAlwaysNull((ValueNode)value)) {
            return;
        }
        this.addPostWriteBarrier(graph, (FixedAccessNode)node, node.getAddress());
    }

    protected void addPostWriteBarrier(StructuredGraph graph, FixedAccessNode node, AddressNode address) {
        PostWriteBarrierNode barrierNode = new PostWriteBarrierNode(address);
        graph.addAfterFixed((FixedWithNextNode)node, (FixedNode)graph.add((Node)barrierNode));
    }

    protected InsertWriteBarrierPhase() {
    }
}

