/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

public final class ProjectHeaderFile {
    public static String resolve(String projectName, String headerFile) {
        HeaderResolversRegistry resolvers = (HeaderResolversRegistry)ImageSingletons.lookup(HeaderResolversRegistry.class);
        return resolvers.resolve(projectName, headerFile);
    }

    public static class FallbackHeaderResolver
    implements HeaderResolver {
        final String projectsDir;

        public FallbackHeaderResolver(String projectsDir) {
            this.projectsDir = projectsDir;
        }

        @Override
        public HeaderSearchResult resolveHeader(String projectName, String headerFile) {
            Path fallbackHeaderFile = Paths.get(this.projectsDir, new String[0]).resolve(projectName).resolve(headerFile).normalize().toAbsolutePath();
            if (Files.exists(fallbackHeaderFile, new LinkOption[0])) {
                return new HeaderSearchResult(Optional.of("\"" + fallbackHeaderFile + "\""), fallbackHeaderFile.toString());
            }
            return new HeaderSearchResult(Optional.empty(), fallbackHeaderFile.toString());
        }
    }

    static class MainHeaderResolver
    implements HeaderResolver {
        MainHeaderResolver() {
        }

        @Override
        public HeaderSearchResult resolveHeader(String projectName, String headerFile) {
            ArrayList<String> locations = new ArrayList<String>();
            String[] clibPathComponents = SubstrateOptions.CLibraryPath.getValue().split(",");
            for (int i = 0; i < clibPathComponents.length; ++i) {
                Path clibPathHeaderFile = Paths.get(clibPathComponents[i], new String[0]).resolve(headerFile).normalize().toAbsolutePath();
                locations.add(clibPathHeaderFile.toString());
                if (!Files.exists(clibPathHeaderFile, new LinkOption[0])) continue;
                return new HeaderSearchResult(Optional.of("\"" + clibPathHeaderFile + "\""), locations);
            }
            return new HeaderSearchResult(Optional.empty(), locations);
        }
    }

    public static class HeaderSearchResult {
        Optional<String> header;
        protected List<String> locations;

        public HeaderSearchResult(Optional<String> headerFile, List<String> locations) {
            this.header = headerFile;
            this.locations = locations;
        }

        public HeaderSearchResult(Optional<String> headerFile, String ... locations) {
            this.header = headerFile;
            this.locations = Arrays.asList(locations);
        }
    }

    public static interface HeaderResolver {
        public HeaderSearchResult resolveHeader(String var1, String var2);
    }

    public static class HeaderResolversRegistry {
        private MainHeaderResolver mainResolver = new MainHeaderResolver();
        private List<HeaderResolver> fallbackResolvers = new ArrayList<HeaderResolver>();

        public static void registerAdditionalResolver(HeaderResolver resolver) {
            assert (ImageSingletons.contains(HeaderResolversRegistry.class));
            HeaderResolversRegistry registry = (HeaderResolversRegistry)ImageSingletons.lookup(HeaderResolversRegistry.class);
            registry.register(resolver);
        }

        private void register(HeaderResolver resolver) {
            this.fallbackResolvers.add(resolver);
        }

        public String resolve(String projectName, String headerFile) {
            HeaderSearchResult mainResult = this.mainResolver.resolveHeader(projectName, headerFile);
            if (mainResult.header.isPresent()) {
                return mainResult.header.get();
            }
            ArrayList<String> fallbackLocations = new ArrayList<String>();
            for (HeaderResolver resolver : this.fallbackResolvers) {
                HeaderSearchResult result = resolver.resolveHeader(projectName, headerFile);
                fallbackLocations.addAll(result.locations);
                if (!result.header.isPresent()) continue;
                return result.header.get();
            }
            throw VMError.shouldNotReachHere("Header file " + headerFile + " not found at main search location(s): \n" + String.join((CharSequence)"\n", mainResult.locations) + (fallbackLocations.size() > 0 ? "\n or any of the fallback locations: \n" + String.join((CharSequence)"\n", fallbackLocations) : "") + "\n Use option -H:CLibraryPath to specify header file search locations.");
        }
    }

    public static abstract class RegisterFallbackResolverFeature
    implements Feature {
        public List<Class<? extends Feature>> getRequiredFeatures() {
            return Collections.singletonList(HeaderResolverRegistrationFeature.class);
        }
    }

    @AutomaticFeature
    public static class HeaderResolverRegistrationFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(HeaderResolversRegistry.class, (Object)new HeaderResolversRegistry());
        }
    }

    @AutomaticFeature
    public static class RegisterSVMTestingResolverFeature
    extends RegisterFallbackResolverFeature {
        public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
            return access.findClassByName("com.oracle.svm.tutorial.CInterfaceTutorial") != null;
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            HeaderResolversRegistry.registerAdditionalResolver(new FallbackHeaderResolver("../../graal/substratevm/src"));
        }
    }
}

