/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.amd64;

import com.oracle.svm.core.config.ConfigurationValues;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public final class FrameAccess {
    @Platforms(value={Platform.AMD64.class})
    public static CodePointer readReturnAddress(Pointer sourceSp) {
        return (CodePointer)sourceSp.readWord(-FrameAccess.returnAddressSize());
    }

    @Platforms(value={Platform.AMD64.class})
    public static void writeReturnAddress(Pointer sourceSp, CodePointer newReturnAddress) {
        sourceSp.writeWord(-FrameAccess.returnAddressSize(), (WordBase)newReturnAddress);
    }

    @Fold
    public static int returnAddressSize() {
        return ConfigurationValues.getTarget().arch.getReturnAddressSize();
    }

    public static int wordSize() {
        return ConfigurationValues.getTarget().arch.getWordSize();
    }

    public static int uncompressedReferenceSize() {
        return FrameAccess.wordSize();
    }

    public static JavaKind getWordKind() {
        return ConfigurationValues.getTarget().wordJavaKind;
    }

    public static Stamp getWordStamp() {
        return StampFactory.forKind((JavaKind)ConfigurationValues.getTarget().wordJavaKind);
    }
}

