package com.oracle.svm.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

/**
 * This foreign access factory is generated by {@link com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.svm.truffle.nfi.ErrnoMirror}.
 */
public final class ErrnoMirrorMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new ErrnoMirrorMessageResolutionForeign(), IsErrnoMirrorSubNode.createRoot());
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new ErrnoMirrorMessageResolutionForeign(), IsErrnoMirrorSubNode.createRoot()); }

    private ErrnoMirrorMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(IsErrnoMirrorSubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(true));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ExecuteErrnoMirrorSubNode.createRoot());
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(InvokeErrnoMirrorSubNode.createRoot());
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution.ExecuteErrnoMirror}.
     */
    abstract static class ExecuteErrnoMirrorSubNode extends com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution.ExecuteErrnoMirror {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.svm.truffle.nfi.ErrnoMirror receiver, java.lang.Object[] args) {
            return access(receiver, args);
        }
        private static final class EXECUTERootNode extends RootNode {
            protected EXECUTERootNode() {
                super(null);
            }

            @Child private ExecuteErrnoMirrorSubNode node = com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolutionForeignFactory.ExecuteErrnoMirrorSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::EXECUTE::" + com.oracle.svm.truffle.nfi.ErrnoMirror.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  List<Object> arguments = ForeignAccess.getArguments(frame);
                  Object[] args = new Object[arguments.size()];
                  for (int i = 0; i < arguments.size(); i++) {
                    args[i] = arguments.get(i);
                  }
                  return node.executeWithTarget(frame, receiver, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ExecuteErrnoMirrorSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new EXECUTERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution.InvokeErrnoMirror}.
     */
    abstract static class InvokeErrnoMirrorSubNode extends com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution.InvokeErrnoMirror {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.svm.truffle.nfi.ErrnoMirror receiver, java.lang.String method, java.lang.Object[] args) {
            return access(receiver, method, args);
        }
        private static final class INVOKERootNode extends RootNode {
            protected INVOKERootNode() {
                super(null);
            }

            @Child private InvokeErrnoMirrorSubNode node = com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolutionForeignFactory.InvokeErrnoMirrorSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::INVOKE::" + com.oracle.svm.truffle.nfi.ErrnoMirror.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  List<Object> arguments = ForeignAccess.getArguments(frame);
                  Object identifier = arguments.get(0);
                  Object[] args = new Object[arguments.size() - 1];
                  for (int i = 0; i < arguments.size() - 1; i++) {
                    args[i] = arguments.get(i + 1);
                  }
                  return node.executeWithTarget(frame, receiver, identifier, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof InvokeErrnoMirrorSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new INVOKERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution.IsErrnoMirror}.
     * Generated for {@link com.oracle.svm.truffle.nfi.ErrnoMirror}.
     */
    abstract static class IsErrnoMirrorSubNode extends com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolution.IsErrnoMirror {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject object) {
            return test(object);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private IsErrnoMirrorSubNode node = com.oracle.svm.truffle.nfi.ErrnoMirrorMessageResolutionForeignFactory.IsErrnoMirrorSubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsErrnoMirrorSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
