/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Field;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

class ReflectionHelper {
    ReflectionHelper() {
    }

    static Target_java_lang_reflect_Executable getHolder(Target_java_lang_reflect_Executable executable) {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getRoot(executable);
        if (holder == null) {
            holder = executable;
        }
        return holder;
    }

    static Target_java_lang_reflect_Constructor getHolder(Target_java_lang_reflect_Constructor constructor) {
        Target_java_lang_reflect_Constructor holder = ReflectionHelper.asConstructor(ReflectionHelper.getRoot(ReflectionHelper.asExecutable(constructor)));
        if (holder == null) {
            holder = constructor;
        }
        return holder;
    }

    static Target_java_lang_reflect_Field getHolder(Target_java_lang_reflect_Field field) {
        Target_java_lang_reflect_Field holder = field.root;
        if (holder == null) {
            holder = field;
        }
        return holder;
    }

    static <T> T requireNonNull(T object, String errorMessage) {
        if (object == null) {
            throw VMError.shouldNotReachHere(errorMessage);
        }
        return object;
    }

    private static Target_java_lang_reflect_Constructor asConstructor(Target_java_lang_reflect_Executable executable) {
        return KnownIntrinsics.unsafeCast(executable, Target_java_lang_reflect_Constructor.class);
    }

    private static Target_java_lang_reflect_Executable asExecutable(Object executable) {
        return KnownIntrinsics.unsafeCast(executable, Target_java_lang_reflect_Executable.class);
    }

    private static Target_java_lang_reflect_Executable getRoot(Target_java_lang_reflect_Executable executable) {
        if (JavaVersionUtil.Java8OrEarlier) {
            return executable.getRoot();
        }
        return ReflectionHelper.asExecutable(KnownIntrinsics.unsafeCast(executable, Target_java_lang_reflect_AccessibleObject.class).getRoot());
    }
}

