/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.annotation.CustomSubstitution;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.reflect.helpers.ReflectionProxy;
import com.oracle.svm.reflect.hosted.ReflectionSubstitutionType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

final class ReflectionSubstitution
extends CustomSubstitution<ReflectionSubstitutionType> {
    private static final String PROXY_NAME_SEPARATOR = "_";
    private final ClassInitializationSupport classInitializationSupport;
    private final Method defineClass;
    private final Method resolveClass;
    private final ResolvedJavaType reflectionProxy;
    private final ResolvedJavaType javaLangReflectProxy;
    private final HashMap<Member, Class<?>> proxyMap = new HashMap();
    private final HashMap<ResolvedJavaType, Member> typeToMember = new HashMap();
    private static final UninterruptibleUtils.AtomicInteger proxyNr = new UninterruptibleUtils.AtomicInteger(0);
    private final ImageClassLoader imageClassLoader;
    private static Method generateProxyMethod;

    private static Method lookupPrivateMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            Method m = clazz.getDeclaredMethod(name, args);
            m.setAccessible(true);
            return m;
        }
        catch (Exception ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    ReflectionSubstitution(MetaAccessProvider metaAccess, ClassInitializationSupport initializationSupport, ImageClassLoader classLoader) {
        super(metaAccess);
        this.defineClass = ReflectionSubstitution.lookupPrivateMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        this.resolveClass = ReflectionSubstitution.lookupPrivateMethod(ClassLoader.class, "resolveClass", Class.class);
        this.reflectionProxy = metaAccess.lookupJavaType(ReflectionProxy.class);
        this.javaLangReflectProxy = metaAccess.lookupJavaType(Proxy.class);
        this.classInitializationSupport = initializationSupport;
        this.imageClassLoader = classLoader;
    }

    static String getStableProxyName(Member member) {
        return "com.oracle.svm.reflect." + SubstrateUtil.uniqueShortName(member);
    }

    private static Class<?> getAccessorInterface(Member member) {
        if (member instanceof Field) {
            return ReflectionSubstitution.packageJdkInternalReflectClassForName("FieldAccessor");
        }
        if (member instanceof Method) {
            return ReflectionSubstitution.packageJdkInternalReflectClassForName("MethodAccessor");
        }
        if (member instanceof Constructor) {
            return ReflectionSubstitution.packageJdkInternalReflectClassForName("ConstructorAccessor");
        }
        throw VMError.shouldNotReachHere();
    }

    private static Class<?> packageJdkInternalReflectClassForName(String className) {
        String packageName = JavaVersionUtil.Java8OrEarlier ? "sun.reflect." : "jdk.internal.reflect.";
        try {
            return Class.forName(packageName + className);
        }
        catch (ClassNotFoundException cnfe) {
            throw VMError.shouldNotReachHere(cnfe);
        }
    }

    private static byte[] generateProxyClass(String name, Class<?>[] interfaces) {
        try {
            if (generateProxyMethod == null) {
                String packageName = JavaVersionUtil.Java8OrEarlier ? "sun.misc." : "java.lang.reflect.";
                generateProxyMethod = Class.forName(packageName + "ProxyGenerator").getDeclaredMethod("generateProxyClass", String.class, Class[].class);
                generateProxyMethod.setAccessible(true);
            }
            return (byte[])generateProxyMethod.invoke(null, name, interfaces);
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    Class<?> getProxyClass(Member member) {
        Class ret = this.proxyMap.get(member);
        if (ret == null) {
            String name = ReflectionSubstitution.getStableProxyName(member) + PROXY_NAME_SEPARATOR + proxyNr.incrementAndGet();
            Class<?> iface = ReflectionSubstitution.getAccessorInterface(member);
            byte[] proxyBC = ReflectionSubstitution.generateProxyClass(name, new Class[]{iface, ReflectionProxy.class});
            try {
                ret = (Class)this.defineClass.invoke((Object)this.imageClassLoader.getClassLoader(), name, proxyBC, 0, proxyBC.length);
                this.resolveClass.invoke((Object)this.imageClassLoader.getClassLoader(), ret);
                this.proxyMap.put(member, ret);
                ResolvedJavaType type = this.metaAccess.lookupJavaType(ret);
                this.typeToMember.put(type, member);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        this.classInitializationSupport.forceInitializeHierarchy(ret);
        return ret;
    }

    private boolean isReflectionProxy(ResolvedJavaType type) {
        return this.reflectionProxy.isAssignableFrom(type) && this.javaLangReflectProxy.isAssignableFrom(type);
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (this.isReflectionProxy(type)) {
            return this.getSubstitution(type);
        }
        return type;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ReflectionSubstitutionType declaringClass;
        ReflectionSubstitutionType.ReflectionSubstitutionMethod result;
        if (this.isReflectionProxy(method.getDeclaringClass()) && (result = (ReflectionSubstitutionType.ReflectionSubstitutionMethod)(declaringClass = this.getSubstitution(method.getDeclaringClass())).getSubstitutionMethod(method)) != null) {
            return result;
        }
        return method;
    }

    public ResolvedJavaType resolve(ResolvedJavaType type) {
        if (type instanceof ReflectionSubstitutionType) {
            return ((ReflectionSubstitutionType)type).getOriginal();
        }
        return type;
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof ReflectionSubstitutionType.ReflectionSubstitutionMethod) {
            return ((ReflectionSubstitutionType.ReflectionSubstitutionMethod)method).getOriginal();
        }
        return method;
    }

    private ReflectionSubstitutionType getSubstitution(ResolvedJavaType original) {
        ReflectionSubstitutionType subst = (ReflectionSubstitutionType)this.getSubstitutionType(original);
        if (subst == null) {
            Member member = this.typeToMember.get(original);
            subst = new ReflectionSubstitutionType(original, member);
            this.addSubstitutionType(original, subst);
        }
        return subst;
    }
}

