/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.substitute.AnnotatedField;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;

public class DeletedMethod
extends CustomSubstitutionMethod {
    public static final String NATIVE_MESSAGE = String.format("Native method. If you intend to use the Java Native Interface (JNI), specify %1$s+JNI and see also %1$sJNIConfigurationFiles=<path> (use %1$s+PrintFlags for details)", "-H:");
    private final Delete deleteAnnotation;
    public static final Method reportErrorMethod;

    public DeletedMethod(ResolvedJavaMethod original, Delete deleteAnnotation) {
        super(original);
        this.deleteAnnotation = deleteAnnotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return AnnotatedField.appendAnnotationTo(this.original.getAnnotations(), this.deleteAnnotation);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotatedField.appendAnnotationTo(this.original.getDeclaredAnnotations(), this.deleteAnnotation);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass.isInstance(this.deleteAnnotation)) {
            return (T)((Annotation)annotationClass.cast(this.deleteAnnotation));
        }
        return (T)this.original.getAnnotation(annotationClass);
    }

    @Override
    public int getModifiers() {
        return this.original.getModifiers() & 0xFFFFFFDF;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        return DeletedMethod.buildGraph(debug, method, providers, this.deleteAnnotation.value());
    }

    public static StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, String message) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
        StructuredGraph graph = kit.getGraph();
        FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
        state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
        int bci = 0;
        graph.start().setStateAfter(state.create(bci++, (StateSplit)graph.start()));
        String msg = AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)method, message, false);
        ConstantNode msgNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(msg), (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
        InvokeWithExceptionNode exceptionNode = kit.createInvokeWithExceptionAndUnwind(providers.getMetaAccess().lookupJavaMethod((Executable)reportErrorMethod), CallTargetNode.InvokeKind.Static, state, bci++, bci++, new ValueNode[]{msgNode});
        kit.append((ValueNode)new UnwindNode((ValueNode)exceptionNode));
        kit.mergeUnwinds();
        assert (graph.verify());
        return graph;
    }

    static {
        try {
            reportErrorMethod = VMError.class.getDeclaredMethod("unsupportedFeature", String.class);
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

