/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.nodes.AnalysisArraysCopyOfNode;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionLoadNode;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionStoreNode;
import com.oracle.graal.pointsto.nodes.ConvertUnknownValueNode;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOfNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.nodes.FarReturnNode;
import com.oracle.svm.core.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.nodes.NewPinnedArrayNode;
import com.oracle.svm.core.graal.nodes.NewPinnedInstanceNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.ReadInstructionPointerNode;
import com.oracle.svm.core.graal.nodes.ReadRegisterFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReturnAddressNode;
import com.oracle.svm.core.graal.nodes.ReadStackPointerNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateDynamicNewArrayNode;
import com.oracle.svm.core.graal.nodes.SubstrateDynamicNewInstanceNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceAccessImpl;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.GraalEdgeUnsafePartition;
import com.oracle.svm.hosted.snippets.Options;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.replacements.nodes.BasicObjectCloneNode;
import org.graalvm.compiler.word.WordCastNode;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import sun.misc.Unsafe;

public class SubstrateGraphBuilderPlugins {
    public static void registerInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutions, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, BytecodeProvider bytecodeProvider, boolean analysis) {
        SubstrateGraphBuilderPlugins.registerSystemPlugins(metaAccess, plugins);
        SubstrateGraphBuilderPlugins.registerImageInfoPlugins(metaAccess, plugins);
        SubstrateGraphBuilderPlugins.registerProxyPlugins(snippetReflection, annotationSubstitutions, plugins, analysis);
        SubstrateGraphBuilderPlugins.registerAtomicUpdaterPlugins(metaAccess, snippetReflection, plugins, analysis);
        SubstrateGraphBuilderPlugins.registerObjectPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(plugins);
        SubstrateGraphBuilderPlugins.registerKnownIntrinsicsPlugins(plugins, analysis);
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerPinnedAllocatorPlugins(constantReflection, plugins);
        SubstrateGraphBuilderPlugins.registerArraysPlugins(plugins, analysis);
        SubstrateGraphBuilderPlugins.registerArrayPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerClassPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerEdgesPlugins(metaAccess, plugins, analysis);
        SubstrateGraphBuilderPlugins.registerJFRThrowablePlugins(plugins, bytecodeProvider);
        SubstrateGraphBuilderPlugins.registerJFREventTokenPlugins(plugins, bytecodeProvider);
        SubstrateGraphBuilderPlugins.registerVMConfigurationPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerPlatformPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerSizeOfPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerReferenceAccessPlugins(plugins);
    }

    private static void registerSystemPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins) {
        InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, System.class);
        proxyRegistration.register0("getSecurityManager", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(null), (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
    }

    private static void registerImageInfoPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins) {
        InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, ImageInfo.class);
        proxyRegistration.register0("inImageCode", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        proxyRegistration.register0("inImageBuildtimeCode", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.FALSE, (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        proxyRegistration.register0("inImageRuntimeCode", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
    }

    private static void registerProxyPlugins(final SnippetReflectionProvider snippetReflection, final AnnotationSubstitutionProcessor annotationSubstitutions, InvocationPlugins plugins, boolean analysis) {
        if (analysis) {
            InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, Proxy.class);
            proxyRegistration.register2("getProxyClass", ClassLoader.class, Class[].class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classLoaderNode, ValueNode interfacesNode) {
                    SubstrateGraphBuilderPlugins.interceptProxyInterfaces(b, targetMethod, snippetReflection, annotationSubstitutions, interfacesNode);
                    return false;
                }
            });
            proxyRegistration.register3("newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classLoaderNode, ValueNode interfacesNode, ValueNode invocationHandlerNode) {
                    SubstrateGraphBuilderPlugins.interceptProxyInterfaces(b, targetMethod, snippetReflection, annotationSubstitutions, interfacesNode);
                    return false;
                }
            });
        }
    }

    private static void interceptProxyInterfaces(GraphBuilderContext b, ResolvedJavaMethod targetMethod, SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode interfacesNode) {
        Object[] interfaces = SubstrateGraphBuilderPlugins.extractClassArray(snippetReflection, annotationSubstitutions, interfacesNode);
        if (interfaces != null) {
            ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).addProxyClass((Class<?>[])interfaces);
            ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).addAutoProxyInvoke(b.getMethod(), b.bci());
            if (Options.DynamicProxyTracing.getValue().booleanValue()) {
                System.out.println("Successfully determined constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + b.getGraph().method().format("%H.%n(%p)") + ". Registered proxy class for " + Arrays.toString(interfaces) + ".");
            }
        } else if (Options.DynamicProxyTracing.getValue().booleanValue() && !b.parsingIntrinsic()) {
            System.out.println("Could not determine constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + b.getGraph().method().format("%H.%n(%p)") + ".");
        }
    }

    static Class<?>[] extractClassArray(SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode arrayNode) {
        return SubstrateGraphBuilderPlugins.extractClassArray(annotationSubstitutions, snippetReflection, arrayNode, false);
    }

    static Class<?>[] extractClassArray(AnnotationSubstitutionProcessor annotationSubstitutions, SnippetReflectionProvider snippetReflection, ValueNode arrayNode, boolean exact) {
        if (arrayNode.isConstant() && !exact) {
            Class[] classes = (Class[])snippetReflection.asObject(Class[].class, arrayNode.asJavaConstant());
            return classes == null ? null : (Stream.of(classes).allMatch(Objects::nonNull) ? classes : null);
        }
        if (arrayNode instanceof NewArrayNode) {
            NewArrayNode newArray = (NewArrayNode)arrayNode;
            ValueNode newArrayLengthNode = newArray.length();
            if (!newArrayLengthNode.isJavaConstant()) {
                return null;
            }
            assert (newArrayLengthNode.asJavaConstant().getJavaKind() == JavaKind.Int);
            ArrayList classList = new ArrayList();
            assert (newArray.successors().count() <= 1) : "Detected node with multiple successors: " + newArray;
            Node successor = newArray.successors().first();
            while (successor instanceof StoreIndexedNode) {
                StoreIndexedNode store = (StoreIndexedNode)successor;
                assert (store.array().equals(newArray));
                ValueNode valueNode = store.value();
                if (!valueNode.isConstant() || valueNode.isNullConstant()) {
                    classList = null;
                    break;
                }
                Class clazz = (Class)snippetReflection.asObject(Class.class, valueNode.asJavaConstant());
                classList.add(annotationSubstitutions.getTargetClass(clazz));
                assert (store.successors().count() <= 1) : "Detected node with multiple successors: " + store;
                successor = store.successors().first();
            }
            int newArrayLength = newArrayLengthNode.asJavaConstant().asInt();
            return classList != null && classList.size() == newArrayLength ? classList.toArray(new Class[0]) : null;
        }
        return null;
    }

    private static void registerAtomicUpdaterPlugins(final MetaAccessProvider metaAccess, final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, final boolean analysis) {
        InvocationPlugins.Registration referenceUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicReferenceFieldUpdater.class);
        referenceUpdaterRegistration.register3("newUpdater", Class.class, Class.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode vclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(metaAccess, snippetReflection, analysis, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration integerUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicIntegerFieldUpdater.class);
        integerUpdaterRegistration.register2("newUpdater", Class.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(metaAccess, snippetReflection, analysis, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration longUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicLongFieldUpdater.class);
        longUpdaterRegistration.register2("newUpdater", Class.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(metaAccess, snippetReflection, analysis, tclassNode, fieldNameNode);
                return false;
            }
        });
    }

    private static void interceptUpdaterInvoke(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, boolean analysis, ValueNode tclassNode, ValueNode fieldNameNode) {
        if (analysis && tclassNode.isConstant() && fieldNameNode.isConstant()) {
            Class tclass = (Class)snippetReflection.asObject(Class.class, tclassNode.asJavaConstant());
            String fieldName = (String)snippetReflection.asObject(String.class, fieldNameNode.asJavaConstant());
            try {
                Field field = tclass.getDeclaredField(fieldName);
                RuntimeReflection.register((Class[])new Class[]{tclass});
                RuntimeReflection.register((Field[])new Field[]{field});
                AnalysisField targetField = (AnalysisField)metaAccess.lookupJavaField(field);
                targetField.registerAsAccessed();
                targetField.registerAsUnsafeAccessed();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Object.class);
        r.register1("clone", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, (ValueNode)SubstrateGraphBuilderPlugins.objectCloneNode(b.getInvokeKind(), b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), targetMethod, object));
                return true;
            }
        });
    }

    public static BasicObjectCloneNode objectCloneNode(CallTargetNode.InvokeKind invokeKind, int bci, StampPair invokeReturnStamp, ResolvedJavaMethod targetMethod, ValueNode receiver) {
        return new SubstrateObjectCloneNode(invokeKind, targetMethod, bci, invokeReturnStamp, receiver);
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Unsafe.class).setAllowOverwrite(true);
        r.register2("allocateInstance", InvocationPlugin.Receiver.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazz) {
                ValueNode clazzNonNull = b.nullCheckedValue(clazz, DeoptimizationAction.None);
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateDynamicNewInstanceNode(clazzNonNull));
                return true;
            }
        });
    }

    private static void registerArrayPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Array.class).setAllowOverwrite(true);
        r.register2("newInstance", Class.class, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazz, ValueNode length) {
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateDynamicNewArrayNode(clazz, length));
                return true;
            }
        });
        r.register1("getLength", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode array) {
                return false;
            }
        });
    }

    private static void registerArraysPlugins(InvocationPlugins plugins, final boolean analysis) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Arrays.class).setAllowOverwrite(true);
        r.register2("copyOf", Object[].class, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode original, ValueNode newLength) {
                if (analysis) {
                    b.addPush(JavaKind.Object, (ValueNode)new AnalysisArraysCopyOfNode(b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp(), original, newLength));
                } else {
                    GetClassNode originalArrayType = (GetClassNode)b.add((ValueNode)new GetClassNode(original.stamp(NodeView.DEFAULT), b.nullCheckedValue(original)));
                    ValueNode originalLength = b.add(ArrayLengthNode.create((ValueNode)original, (ConstantReflectionProvider)b.getConstantReflection()));
                    Stamp stamp = b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp().join(original.stamp(NodeView.DEFAULT));
                    b.addPush(JavaKind.Object, (ValueNode)new SubstrateArraysCopyOfNode(stamp, original, originalLength, newLength, (ValueNode)originalArrayType));
                }
                return true;
            }
        });
        r.register3("copyOf", Object[].class, Integer.TYPE, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode original, ValueNode newLength, ValueNode newArrayType) {
                if (analysis) {
                    b.addPush(JavaKind.Object, (ValueNode)new AnalysisArraysCopyOfNode(b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp(), original, newLength, newArrayType));
                } else {
                    Stamp stamp;
                    if (newArrayType.isConstant()) {
                        ResolvedJavaType newType = b.getConstantReflection().asJavaType(newArrayType.asConstant());
                        stamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)newType));
                    } else {
                        stamp = b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp();
                    }
                    ValueNode originalLength = b.add(ArrayLengthNode.create((ValueNode)original, (ConstantReflectionProvider)b.getConstantReflection()));
                    b.addPush(JavaKind.Object, (ValueNode)new SubstrateArraysCopyOfNode(stamp, original, originalLength, newLength, newArrayType));
                }
                return true;
            }
        });
    }

    private static void registerKnownIntrinsicsPlugins(InvocationPlugins plugins, final boolean analysis) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, KnownIntrinsics.class);
        r.register0("heapBase", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)ReadRegisterFixedNode.forHeapBase());
                return true;
            }
        });
        r.register1("readArrayLength", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array) {
                b.addPush(JavaKind.Int, (ValueNode)new ArrayLengthNode(array));
                return true;
            }
        });
        r.register1("readHub", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                ValueNode nonNullObject = b.nullCheckedValue(object);
                b.addPush(JavaKind.Object, (ValueNode)new LoadHubNode(b.getStampProvider(), nonNullObject));
                return true;
            }
        });
        r.register3("formatObject", Pointer.class, Class.class, Boolean.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode memory, ValueNode hub, ValueNode rememberedSet) {
                b.addPush(JavaKind.Object, (ValueNode)new FormatObjectNode(memory, hub, rememberedSet));
                return true;
            }
        });
        r.register5("formatArray", Pointer.class, Class.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode memory, ValueNode hub, ValueNode length, ValueNode rememberedSet, ValueNode unaligned) {
                b.addPush(JavaKind.Object, (ValueNode)new FormatArrayNode(memory, hub, length, rememberedSet, unaligned));
                return true;
            }
        });
        r.register2("unsafeCast", Object.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode toTypeNode) {
                ResolvedJavaType toType = SubstrateGraphBuilderPlugins.typeValue(b.getConstantReflection(), b, targetMethod, toTypeNode, "toType");
                TypeReference toTypeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)toType);
                b.addPush(JavaKind.Object, (ValueNode)new FixedValueAnchorNode(object, (Stamp)StampFactory.object((TypeReference)toTypeRef)));
                return true;
            }
        });
        r.register1("nonNullPointer", Pointer.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Object, (ValueNode)new PiNode(object, (Stamp)SubstrateGraphBuilderPlugins.nonZeroWord()));
                return true;
            }
        });
        r.register0("readStackPointer", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new ReadStackPointerNode());
                return true;
            }
        });
        r.register0("readInstructionPointer", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new ReadInstructionPointerNode());
                return true;
            }
        });
        r.register0("readCallerStackPointer", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new ReadCallerStackPointerNode());
                return true;
            }
        });
        r.register0("readReturnAddress", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new ReadReturnAddressNode());
                return true;
            }
        });
        r.register3("farReturn", Object.class, Pointer.class, CodePointer.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode result, ValueNode sp, ValueNode ip) {
                b.add((ValueNode)new FarReturnNode(result, sp, ip));
                return true;
            }
        });
        r.register0("testDeoptimize", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add((ValueNode)new TestDeoptimizeNode());
                return true;
            }
        });
        r.register0("isDeoptimizationTarget", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (b.getGraph().method() instanceof SharedMethod) {
                    SharedMethod method = (SharedMethod)b.getGraph().method();
                    if (method.isDeoptTarget()) {
                        b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)true));
                    } else {
                        b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)false));
                    }
                } else {
                    b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)true));
                }
                return true;
            }
        });
        r.register2("convertUnknownValue", Object.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode typeNode) {
                ResolvedJavaType type = SubstrateGraphBuilderPlugins.typeValue(b.getConstantReflection(), b, targetMethod, typeNode, "type");
                TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)type);
                ObjectStamp stamp = StampFactory.object((TypeReference)typeRef);
                if (analysis) {
                    b.addPush(JavaKind.Object, (ValueNode)new ConvertUnknownValueNode(object, (Stamp)stamp));
                } else {
                    b.addPush(JavaKind.Object, PiNode.create((ValueNode)object, (Stamp)stamp));
                }
                return true;
            }
        });
    }

    private static IntegerStamp nonZeroWord() {
        return StampFactory.forUnsignedInteger((int)64, (long)1L, (long)-1L);
    }

    private static void registerStackValuePlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, StackValue.class);
        r.register1("get", Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sizeNode) {
                long size = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, sizeNode, "size");
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(1L, size, slotIdentity));
                return true;
            }
        });
        r.register1("get", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(1L, size, slotIdentity));
                return true;
            }
        });
        r.register2("get", Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode numElementsNode, ValueNode elementSizeNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                long elementSize = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, elementSizeNode, "elementSize");
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(numElements, elementSize, slotIdentity));
                return true;
            }
        });
        r.register2("get", Integer.TYPE, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode numElementsNode, ValueNode classNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(numElements, size, slotIdentity));
                return true;
            }
        });
    }

    private static void registerPinnedAllocatorPlugins(final ConstantReflectionProvider constantReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, PinnedAllocator.class);
        r.register2("newInstance", InvocationPlugin.Receiver.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver pinnedAllocator, ValueNode instanceClassNode) {
                ResolvedJavaType instanceClass = SubstrateGraphBuilderPlugins.typeValue(constantReflection, b, targetMethod, instanceClassNode, "instanceClass");
                ValueNode pinnedAllocatorNode = pinnedAllocator.get();
                b.addPush(JavaKind.Object, (ValueNode)new NewPinnedInstanceNode(instanceClass, pinnedAllocatorNode));
                return true;
            }
        });
        r.register3("newArray", InvocationPlugin.Receiver.class, Class.class, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver pinnedAllocator, ValueNode componentTypeNode, ValueNode length) {
                ResolvedJavaType componentType = SubstrateGraphBuilderPlugins.typeValue(constantReflection, b, targetMethod, componentTypeNode, "componentType");
                ValueNode pinnedAllocatorNode = pinnedAllocator.get();
                b.addPush(JavaKind.Object, (ValueNode)new NewPinnedArrayNode(componentType, length, pinnedAllocatorNode));
                return true;
            }
        });
    }

    private static ResolvedJavaType typeValue(ConstantReflectionProvider constantReflection, GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode typeNode, String name) {
        if (!typeNode.isConstant()) {
            throw b.bailout("parameter " + name + " is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
        }
        ResolvedJavaType type = constantReflection.asJavaType(typeNode.asConstant());
        if (type == null) {
            throw b.bailout("parameter " + name + " is null for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
        }
        return type;
    }

    private static void registerClassPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class).setAllowOverwrite(true);
        r.register2("isAssignableFrom", InvocationPlugin.Receiver.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode otherType) {
                return false;
            }
        });
    }

    private static void registerEdgesPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins, boolean analysis) {
        if (analysis) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Edges.class).setAllowOverwrite(true);
            for (final Class c : new Class[]{Node.class, NodeList.class}) {
                r.register2("get" + c.getSimpleName() + "Unsafe", Node.class, Long.TYPE, new InvocationPlugin(){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset) {
                        b.addPush(JavaKind.Object, (ValueNode)new AnalysisUnsafePartitionLoadNode(node, offset, JavaKind.Object, LocationIdentity.any(), GraalEdgeUnsafePartition.get(), metaAccess.lookupJavaType(c)));
                        return true;
                    }
                });
                r.register3("put" + c.getSimpleName() + "Unsafe", Node.class, Long.TYPE, (Type)c, new InvocationPlugin(){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset, ValueNode value) {
                        b.add((ValueNode)new AnalysisUnsafePartitionStoreNode(node, offset, value, JavaKind.Object, LocationIdentity.any(), GraalEdgeUnsafePartition.get(), metaAccess.lookupJavaType(c)));
                        return true;
                    }
                });
            }
        }
    }

    protected static long longValue(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode node, String name) {
        if (!node.isConstant()) {
            throw b.bailout("parameter " + name + " is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
        }
        return node.asJavaConstant().asLong();
    }

    private static void registerJFRThrowablePlugins(InvocationPlugins plugins, BytecodeProvider bytecodeProvider) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "oracle.jrockit.jfr.jdkevents.ThrowableTracer", bytecodeProvider).setAllowOverwrite(true);
        r.register2("traceError", Error.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode throwable, ValueNode message) {
                return true;
            }
        });
        r.register2("traceThrowable", Throwable.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode throwable, ValueNode message) {
                return true;
            }
        });
    }

    private static void registerJFREventTokenPlugins(InvocationPlugins plugins, BytecodeProvider bytecodeProvider) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.jrockit.jfr.EventToken", bytecodeProvider);
        r.register1("isEnabled", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get();
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)false));
                return true;
            }
        });
    }

    private static void registerVMConfigurationPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ImageSingletons.class);
        r.register1("contains", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                boolean result = ImageSingletons.contains((Class)key);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result)));
                return true;
            }
        });
        r.register1("lookup", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                Object result = ImageSingletons.lookup((Class)key);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject(result), (MetaAccessProvider)b.getMetaAccess())));
                return true;
            }
        });
    }

    private static void registerPlatformPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Platform.class);
        r.register1("includedIn", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode) {
                Class platform = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                boolean result = Platform.includedIn((Class)platform);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result)));
                return true;
            }
        });
    }

    private static void registerSizeOfPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, SizeOf.class);
        r.register1("get", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int result = SizeOf.get((Class)clazz);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Int, (ValueNode)ConstantNode.forInt((int)result)));
                return true;
            }
        });
        r.register1("unsigned", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                UnsignedWord result = SizeOf.unsigned((Class)clazz);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject((Object)result), (MetaAccessProvider)b.getMetaAccess())));
                return true;
            }
        });
    }

    private static void registerReferenceAccessPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ReferenceAccessImpl.class);
        r.register2("getCompressedRepresentation", InvocationPlugin.Receiver.class, Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode objectNode) {
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    SubstrateCompressionNode compressedObj = SubstrateCompressionNode.compress(objectNode, (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class));
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    ValueNode compressedValue = b.add((ValueNode)WordCastNode.narrowOopToUntrackedWord((ValueNode)compressedObj, (JavaKind)compressedIntKind));
                    b.addPush(JavaKind.Object, ZeroExtendNode.convertUnsigned((ValueNode)compressedValue, (Stamp)FrameAccess.getWordStamp(), (NodeView)NodeView.DEFAULT));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.objectToUntrackedPointer((ValueNode)objectNode, (JavaKind)FrameAccess.getWordKind()));
                }
                return true;
            }
        });
        r.register2("uncompressReference", InvocationPlugin.Receiver.class, UnsignedWord.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode wordNode) {
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    CompressEncoding encoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    NarrowOopStamp compressedStamp = (NarrowOopStamp)SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)StampFactory.object(), encoding);
                    ValueNode narrowNode = b.add(NarrowNode.convertUnsigned((ValueNode)wordNode, (Stamp)StampFactory.forKind((JavaKind)compressedIntKind), (NodeView)NodeView.DEFAULT));
                    WordCastNode compressedObj = (WordCastNode)b.add((ValueNode)WordCastNode.wordToNarrowObject((ValueNode)narrowNode, (NarrowOopStamp)compressedStamp));
                    b.addPush(JavaKind.Object, (ValueNode)SubstrateCompressionNode.uncompress((ValueNode)compressedObj, encoding));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.wordToObject((ValueNode)wordNode, (JavaKind)FrameAccess.getWordKind()));
                }
                return true;
            }
        });
    }

    private static <T> T constantObjectParameter(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ResolvedJavaMethod targetMethod, int parameterIndex, Class<T> declaredType, ValueNode classNode) {
        SubstrateGraphBuilderPlugins.checkParameterUsage(classNode.isConstant(), b, targetMethod, parameterIndex, "parameter is not a compile time constant");
        Object result = snippetReflection.asObject(declaredType, classNode.asJavaConstant());
        SubstrateGraphBuilderPlugins.checkParameterUsage(result != null, b, targetMethod, parameterIndex, "parameter is null");
        return (T)result;
    }

    private static void checkParameterUsage(boolean condition, GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, String message) {
        Local variable;
        if (condition) {
            return;
        }
        String parameterName = null;
        LocalVariableTable variableTable = targetMethod.getLocalVariableTable();
        if (variableTable != null && (variable = variableTable.getLocal(parameterIndex, 0)) != null) {
            parameterName = variable.getName();
        }
        if (parameterName == null) {
            parameterName = String.valueOf(parameterIndex);
        }
        throw UserError.abort(message + ": parameter " + parameterName + " of call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
    }
}

