/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo
public abstract class AssertValueNode
extends FixedWithNextNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<AssertValueNode> TYPE = NodeClass.create(AssertValueNode.class);
    @Node.Input
    protected ValueNode input;

    protected static void insert(ValueNode input, AssertValueNode assertionNode) {
        StartNode insertionPoint;
        StructuredGraph graph = input.graph();
        if (input instanceof ParameterNode) {
            insertionPoint = graph.start();
        } else if (input instanceof InvokeWithExceptionNode) {
            insertionPoint = ((InvokeWithExceptionNode)input).next();
        } else if (input instanceof FixedWithNextNode) {
            insertionPoint = (FixedWithNextNode)input;
        } else {
            throw VMError.shouldNotReachHere("Node is not fixed: " + input);
        }
        ValueNode proxyUsage = null;
        boolean otherUsages = false;
        for (Node usage : input.usages()) {
            if (usage instanceof ProxyNode && ((ProxyNode)usage).proxyPoint() == insertionPoint) {
                assert (proxyUsage == null) : "can have only one proxy";
                proxyUsage = (ProxyNode)usage;
                continue;
            }
            if (usage instanceof FrameState) continue;
            otherUsages = true;
        }
        assert (proxyUsage == null || !otherUsages) : "cannot have other usages when having a proxy usage";
        ValueNode assertInput = proxyUsage != null ? proxyUsage : input;
        for (Node usage : assertInput.usages().snapshot()) {
            if (usage instanceof FrameState) continue;
            usage.replaceFirstInput((Node)assertInput, (Node)assertionNode);
        }
        assertionNode.updateUsages((Node)assertionNode.input, (Node)assertInput);
        assertionNode.input = assertInput;
        graph.addAfterFixed((FixedWithNextNode)insertionPoint, (FixedNode)assertionNode);
    }

    protected AssertValueNode(NodeClass<? extends AssertValueNode> c, Stamp stamp) {
        super(c, stamp);
    }

    public ValueNode getInput() {
        return this.input;
    }

    public boolean inferStamp() {
        return this.updateStamp(this.stamp(NodeView.DEFAULT).join(this.input.stamp(NodeView.DEFAULT)));
    }

    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.alwaysHolds(false)) {
            return this.getInput();
        }
        return this;
    }

    public void lower(LoweringTool tool) {
        if (!this.alwaysHolds(true)) {
            tool.getLowerer().lower((Node)this, tool);
        }
    }

    protected abstract boolean alwaysHolds(boolean var1);
}

