/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.nodes.AssertValueNode;
import java.util.HashSet;
import java.util.Set;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public class AssertTypeStateNode
extends AssertValueNode
implements Virtualizable {
    public static final NodeClass<AssertTypeStateNode> TYPE = NodeClass.create(AssertTypeStateNode.class);
    protected final JavaTypeProfile typeState;

    public static void create(ValueNode input, JavaTypeProfile typeState) {
        AssertTypeStateNode.insert(input, (AssertValueNode)input.graph().add((Node)new AssertTypeStateNode(input.stamp(NodeView.DEFAULT), typeState)));
    }

    protected AssertTypeStateNode(Stamp stamp, JavaTypeProfile typeState) {
        super(TYPE, stamp);
        this.typeState = typeState;
    }

    public JavaTypeProfile getTypeState() {
        return this.typeState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean alwaysHolds(boolean reportError) {
        if (this.getInput().isConstant()) {
            if (this.getInput().asJavaConstant().isNull()) {
                if (this.typeState.getNullSeen() != TriState.FALSE) return true;
                if (reportError) {
                    throw VMError.shouldNotReachHere("Null constant not compatible with type state: " + (Object)((Object)this) + " : " + this.getTypeState());
                }
            } else {
                HashSet<ResolvedJavaType> ourTypes = new HashSet<ResolvedJavaType>();
                AssertTypeStateNode.addAllTypes(ourTypes, this.typeState);
                if (ourTypes.contains(StampTool.typeOrNull((ValueNode)this.getInput()))) return true;
                if (reportError) {
                    throw VMError.shouldNotReachHere("Constant object not compatible with type state: " + (Object)((Object)this) + " : " + this.getTypeState() + ", " + StampTool.typeOrNull((ValueNode)this.getInput()));
                }
            }
        }
        if (!(this.getInput() instanceof AssertTypeStateNode)) return false;
        JavaTypeProfile inputTypeState = ((AssertTypeStateNode)this.getInput()).getTypeState();
        HashSet<ResolvedJavaType> inputTypes = new HashSet<ResolvedJavaType>();
        AssertTypeStateNode.addAllTypes(inputTypes, inputTypeState);
        HashSet<ResolvedJavaType> ourTypes = new HashSet<ResolvedJavaType>();
        AssertTypeStateNode.addAllTypes(ourTypes, this.typeState);
        if (!ourTypes.containsAll(inputTypes)) return false;
        return true;
    }

    private static void addAllTypes(Set<ResolvedJavaType> set, JavaTypeProfile types) {
        for (JavaTypeProfile.ProfiledType type : types.getTypes()) {
            set.add(type.getType());
        }
    }

    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getInput());
        if (alias instanceof VirtualObjectNode) {
            HashSet<ResolvedJavaType> ourTypes = new HashSet<ResolvedJavaType>();
            AssertTypeStateNode.addAllTypes(ourTypes, this.typeState);
            if (!ourTypes.contains(StampTool.typeOrNull((ValueNode)alias))) {
                throw VMError.shouldNotReachHere("Virtual object not compatible with type state: " + (Object)((Object)this) + " : " + this.getTypeState() + ", " + alias.stamp(NodeView.DEFAULT));
            }
            tool.replaceWith(alias);
        }
    }
}

