/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.lambda.LambdaProxyRenamingSubstitutionProcessor;
import java.util.HashSet;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class StableLambdaProxyNameFeature
implements GraalFeature {
    StableLambdaProxyNameFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        LambdaProxyRenamingSubstitutionProcessor lSubst = new LambdaProxyRenamingSubstitutionProcessor(access.getBigBang());
        access.registerSubstitutionProcessor(lSubst);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        assert (StableLambdaProxyNameFeature.checkLambdaNames(((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse().getTypes()));
    }

    private static boolean checkLambdaNames(List<AnalysisType> types) {
        if (!SubstrateUtil.assertionsEnabled()) {
            throw new AssertionError((Object)"Expensive check: should only run with assertions enabled.");
        }
        if (types.stream().anyMatch(LambdaProxyRenamingSubstitutionProcessor::isLambdaType)) {
            throw new AssertionError((Object)"All lambda proxies should be substituted.");
        }
        HashSet lambdaNames = new HashSet();
        types.forEach(t -> {
            if (lambdaNames.contains(t.getName())) {
                throw new AssertionError((Object)("Duplicate lambda name: " + t.getName()));
            }
            lambdaNames.add(t.getName());
        });
        return true;
    }
}

