/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import java.util.zip.ZipFile;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class DisallowedImageHeapObjectFeature
implements Feature {
    private static final Field FILE_DESCRIPTOR_FIELD;

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(DisallowedImageHeapObjectFeature::replacer);
    }

    private static Object replacer(Object original) {
        MappedByteBuffer buffer;
        FileDescriptor asFileDescriptor;
        Thread asThread;
        if (original instanceof Thread && (asThread = (Thread)original).getState() != Thread.State.NEW) {
            throw DisallowedImageHeapObjectFeature.error("Detected a started Thread in the image heap. Threads running in the image generator are no longer running at image run time. ");
        }
        if (original instanceof FileDescriptor && (asFileDescriptor = (FileDescriptor)original) != FileDescriptor.in && asFileDescriptor != FileDescriptor.out && asFileDescriptor != FileDescriptor.err && asFileDescriptor.valid()) {
            throw DisallowedImageHeapObjectFeature.error("Detected a FileDescriptor in the image heap. File descriptors opened during image generation are no longer open at image run time, and the files might not even be present anymore at image run time. ");
        }
        if (original instanceof MappedByteBuffer && ((buffer = (MappedByteBuffer)original).capacity() != 0 || DisallowedImageHeapObjectFeature.getFileDescriptor(buffer) != null)) {
            throw DisallowedImageHeapObjectFeature.error("Detected a direct/mapped ByteBuffer in the image heap. A direct ByteBuffer has a pointer to unmanaged C memory, and C memory from the image generator is not available at image run time. A mapped ByteBuffer references a file descriptor, which is no longer open and mapped at run time. ");
        }
        if (original instanceof ZipFile) {
            throw DisallowedImageHeapObjectFeature.error("Detected a ZipFile object in the image heap. A ZipFile object contains pointers to unmanaged C memory and file descriptors, and these resources are no longer available at image run time. ");
        }
        return original;
    }

    private static RuntimeException error(String msg) {
        throw new UnsupportedFeatureException(msg + "The object was probably created by a class initializer and is reachable from a static field. By default, all class initialization is done during native image building.You can manually delay class initialization to image run time by using the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.DelayClassInitialization, "<class-name>") + ". Or you can write your own initialization methods and call them explicitly from your main entry point.");
    }

    private static FileDescriptor getFileDescriptor(MappedByteBuffer buffer) {
        try {
            return (FileDescriptor)FILE_DESCRIPTOR_FIELD.get(buffer);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    static {
        try {
            FILE_DESCRIPTOR_FIELD = MappedByteBuffer.class.getDeclaredField("fd");
            FILE_DESCRIPTOR_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

