/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ReflectionConfigurationParserDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public class ReflectionRegistryAdapter
implements ReflectionConfigurationParserDelegate<Class<?>> {
    private final ReflectionRegistry registry;
    private final ImageClassLoader classLoader;

    public ReflectionRegistryAdapter(ReflectionRegistry registry, ImageClassLoader classLoader) {
        this.registry = registry;
        this.classLoader = classLoader;
    }

    @Override
    public void registerType(Class<?> type) {
        this.registry.register(new Class[]{type});
    }

    @Override
    public Class<?> resolveType(String typeName) {
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        return this.classLoader.findClassByName(name, false);
    }

    @Override
    public void registerPublicClasses(Class<?> type) {
        this.registry.register((Class[])type.getClasses());
    }

    @Override
    public void registerDeclaredClasses(Class<?> type) {
        this.registry.register((Class[])type.getDeclaredClasses());
    }

    @Override
    public void registerPublicFields(Class<?> type) {
        this.registry.register(false, type.getFields());
    }

    @Override
    public void registerDeclaredFields(Class<?> type) {
        this.registry.register(false, type.getDeclaredFields());
    }

    @Override
    public void registerPublicMethods(Class<?> type) {
        this.registry.register((Executable[])type.getMethods());
    }

    @Override
    public void registerDeclaredMethods(Class<?> type) {
        this.registry.register((Executable[])type.getDeclaredMethods());
    }

    @Override
    public void registerPublicConstructors(Class<?> type) {
        this.registry.register((Executable[])type.getConstructors());
    }

    @Override
    public void registerDeclaredConstructors(Class<?> type) {
        this.registry.register((Executable[])type.getDeclaredConstructors());
    }

    @Override
    public void registerField(Class<?> type, String fieldName, boolean allowWrite) throws NoSuchFieldException {
        this.registry.register(allowWrite, new Field[]{type.getDeclaredField(fieldName)});
    }

    @Override
    public boolean registerAllMethodsWithName(Class<?> type, String methodName) {
        Method[] methods;
        boolean found = false;
        for (Method method : methods = type.getDeclaredMethods()) {
            if (!((Executable)method).getName().equals(methodName)) continue;
            this.registry.register(new Executable[]{method});
            found = true;
        }
        return found;
    }

    @Override
    public boolean registerAllConstructors(Class<?> clazz) {
        Constructor<?>[] methods;
        for (Constructor<?> method : methods = clazz.getDeclaredConstructors()) {
            this.registry.register(new Executable[]{method});
        }
        return methods.length > 0;
    }

    @Override
    public void registerMethod(Class<?> type, String methodName, List<Class<?>> methodParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypesArray = methodParameterTypes.toArray(new Class[0]);
        this.registry.register(new Executable[]{type.getDeclaredMethod(methodName, parameterTypesArray)});
    }

    @Override
    public void registerConstructor(Class<?> clazz, List<Class<?>> methodParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypesArray = methodParameterTypes.toArray(new Class[0]);
        this.registry.register(new Executable[]{clazz.getDeclaredConstructor(parameterTypesArray)});
    }

    @Override
    public String getTypeName(Class<?> type) {
        return type.getTypeName();
    }

    @Override
    public String getSimpleName(Class<?> type) {
        return type.getSimpleName();
    }
}

