/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.code.CompilationResult;

class AArch64MovSequenceHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64Assembler.MovSequenceAnnotation annotation;

    AArch64MovSequenceHostedPatcher(int instructionStartPosition, AArch64Assembler.MovSequenceAnnotation annotation) {
        super(instructionStartPosition);
        this.annotation = annotation;
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int codePos, int relative, byte[] code) {
        int curValue = relative - 4 * this.annotation.numInstrs;
        int bitsRemaining = this.annotation.operandSizeBits;
        for (int i = 0; i < 4 * this.annotation.numInstrs; i += 4) {
            if (bitsRemaining >= 8) {
                code[this.annotation.instructionPosition + i] = (byte)(curValue & 0xFF);
                bitsRemaining -= 8;
            } else {
                int mask = 0;
                for (int j = 0; j < bitsRemaining; ++j) {
                    mask |= 1 << j;
                }
                code[this.annotation.instructionPosition + i] = (byte)((byte)(curValue & mask) | code[this.annotation.instructionPosition] & ~mask);
            }
            curValue >>>= 8;
        }
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        int siteOffset = compStart + this.annotation.instructionPosition;
        if (ref instanceof DataSectionReference || ref instanceof CGlobalDataReference) {
            if (this.annotation.numInstrs == 1) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G0, 2, 0L, ref);
                siteOffset += 4;
            } else if (this.annotation.numInstrs > 1) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G0_NC, 2, 0L, ref);
                siteOffset += 4;
            }
            if (this.annotation.numInstrs == 2) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G1, 2, 0L, ref);
                siteOffset += 4;
            } else if (this.annotation.numInstrs > 2) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G1_NC, 2, 0L, ref);
                siteOffset += 4;
            }
            if (this.annotation.numInstrs == 3) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G2, 2, 0L, ref);
                siteOffset += 4;
            } else if (this.annotation.numInstrs > 3) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G2_NC, 2, 0L, ref);
                siteOffset += 4;
            }
            if (this.annotation.numInstrs == 4) {
                relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_MOVW_UABS_G3, 2, 0L, ref);
                siteOffset += 4;
            }
        } else if (ref instanceof ConstantReference) {
            relocs.addDirectRelocationWithoutAddend(siteOffset, this.annotation.numInstrs * 2, ref);
        } else {
            throw VMError.shouldNotReachHere("Unknown type of reference in code");
        }
    }
}

