/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.CommonClassInitializationSupport;
import com.sun.crypto.provider.SunJCE;
import java.lang.reflect.Proxy;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.options.OptionKey;

public class ConservativeClassInitialization
extends CommonClassInitializationSupport {
    public ConservativeClassInitialization(MetaAccessProvider metaAccess) {
        super(metaAccess);
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz) {
        this.ensureClassInitialized(clazz);
    }

    @Override
    ClassInitializationSupport.InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoize) {
        if (this.classInitKinds.containsKey(clazz)) {
            return (ClassInitializationSupport.InitKind)((Object)this.classInitKinds.get(clazz));
        }
        if (clazz.isAnnotation()) {
            this.forceInitializeHierarchy(clazz);
            return ClassInitializationSupport.InitKind.EAGER;
        }
        if (clazz.isEnum() && !UNSAFE.shouldBeInitialized(clazz)) {
            if (memoize) {
                this.forceInitializeHierarchy(clazz);
            }
            return ClassInitializationSupport.InitKind.EAGER;
        }
        if (clazz.getTypeName().contains("$$Lambda$")) {
            if (memoize) {
                this.forceInitializeHierarchy(clazz);
            }
            return ClassInitializationSupport.InitKind.EAGER;
        }
        ClassInitializationSupport.InitKind result = ConservativeClassInitialization.defaultInitKindForClass(clazz);
        if (clazz.getSuperclass() != null) {
            result = result.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoize));
        }
        result = result.max(this.processInterfaces(clazz, memoize));
        if (memoize) {
            if (!result.isDelayed()) {
                result = result.max(this.ensureClassInitialized(clazz));
            }
            ClassInitializationSupport.InitKind previous = this.classInitKinds.put(clazz, result);
            assert (previous == null || previous == result) : "Overwriting existing value";
        }
        return result;
    }

    private ClassInitializationSupport.InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        ClassInitializationSupport.InitKind result = ConservativeClassInitialization.defaultInitKindForClass(clazz);
        for (Class<?> iface : clazz.getInterfaces()) {
            result = ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(iface)) ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    private static ClassInitializationSupport.InitKind defaultInitKindForClass(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return ClassInitializationSupport.InitKind.EAGER;
        }
        if (clazz.isAnnotation()) {
            return ClassInitializationSupport.InitKind.EAGER;
        }
        if (Proxy.isProxyClass(clazz)) {
            return ClassInitializationSupport.InitKind.EAGER;
        }
        if (clazz.getTypeName().contains("$$Lambda$")) {
            return ClassInitializationSupport.InitKind.EAGER;
        }
        ClassLoader typeClassLoader = clazz.getClassLoader();
        if (typeClassLoader == null || typeClassLoader == NativeImageGenerator.class.getClassLoader() || typeClassLoader == SunJCE.class.getClassLoader() || typeClassLoader == OptionKey.class.getClassLoader()) {
            return ClassInitializationSupport.InitKind.EAGER;
        }
        return ClassInitializationSupport.InitKind.DELAY;
    }
}

