/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public abstract class CommonClassInitializationSupport
implements ClassInitializationSupport {
    static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    final Map<Class<?>, ClassInitializationSupport.InitKind> classInitKinds = new ConcurrentHashMap();
    private UnsupportedFeatures unsupportedFeatures;
    protected MetaAccessProvider metaAccess;

    CommonClassInitializationSupport(MetaAccessProvider metaAccess) {
        this.metaAccess = metaAccess;
    }

    @Override
    public void setUnsupportedFeatures(UnsupportedFeatures unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
    }

    abstract ClassInitializationSupport.InitKind computeInitKindAndMaybeInitializeClass(Class<?> var1, boolean var2);

    ClassInitializationSupport.InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    @Override
    public ClassInitializationSupport.InitKind initKindFor(Class<?> clazz) {
        assert (this.classInitKinds.containsKey(clazz));
        return this.classInitKinds.get(clazz);
    }

    @Override
    public Set<Class<?>> classesWithKind(ClassInitializationSupport.InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        return this.computeInitKindAndMaybeInitializeClass(CommonClassInitializationSupport.toAnalysisType(type).getJavaClass()) != ClassInitializationSupport.InitKind.EAGER;
    }

    @Override
    public boolean shouldInitializeAtRuntime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) != ClassInitializationSupport.InitKind.EAGER;
    }

    @Override
    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(CommonClassInitializationSupport.toAnalysisType(type).getJavaClass());
    }

    @Override
    public void forceInitializeHosted(ResolvedJavaType type) {
        this.forceInitializeHosted(CommonClassInitializationSupport.toAnalysisType(type).getJavaClass());
    }

    ClassInitializationSupport.InitKind ensureClassInitialized(Class<?> clazz) {
        try {
            UNSAFE.ensureClassInitialized(clazz);
            return ClassInitializationSupport.InitKind.EAGER;
        }
        catch (Throwable ex) {
            if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue() || NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                System.out.println("Warning: class initialization of class " + clazz.getTypeName() + " failed with exception " + ex.getClass().getTypeName() + (ex.getMessage() == null ? "" : ": " + ex.getMessage()) + ". This class will be initialized at run time because either option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + " or option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " is used for image building. Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.DelayClassInitialization, clazz.getTypeName()) + " to explicitly request delayed initialization of this class.");
            } else {
                String msg = "Class initialization failed: " + clazz.getTypeName();
                if (this.unsupportedFeatures != null) {
                    this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, ex);
                } else {
                    throw UserError.abort(msg, ex);
                }
            }
            return ClassInitializationSupport.InitKind.MUST_DELAY;
        }
    }

    private static AnalysisType toAnalysisType(ResolvedJavaType type) {
        return type instanceof HostedType ? ((HostedType)type).getWrapped() : (AnalysisType)type;
    }

    public void delayClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            this.metaAccess.lookupJavaType(clazz);
            CommonClassInitializationSupport.checkEagerInitialization(clazz);
            if (!UNSAFE.shouldBeInitialized(clazz)) {
                throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName());
            }
            if (clazz.isAnnotation()) {
                throw UserError.abort("Class initialization of annotation classes cannot be delayed to runtime. Culprit: " + clazz.getTypeName());
            }
            this.computeInitKindAndMaybeInitializeClass(clazz, false);
            ClassInitializationSupport.InitKind previousKind = this.classInitKinds.put(clazz, ClassInitializationSupport.InitKind.MUST_DELAY);
            if (previousKind == ClassInitializationSupport.InitKind.EAGER) {
                throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName());
            }
            if (previousKind != ClassInitializationSupport.InitKind.RERUN) continue;
            throw UserError.abort("Class is registered both for delaying and rerunning the class initializer: " + clazz.getTypeName());
        }
    }

    public void rerunClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            this.metaAccess.lookupJavaType(clazz);
            CommonClassInitializationSupport.checkEagerInitialization(clazz);
            try {
                UNSAFE.ensureClassInitialized(clazz);
            }
            catch (Throwable ex) {
                throw UserError.abort("Class initialization failed: " + clazz.getTypeName(), ex);
            }
            this.computeInitKindAndMaybeInitializeClass(clazz, false);
            ClassInitializationSupport.InitKind previousKind = this.classInitKinds.put(clazz, ClassInitializationSupport.InitKind.RERUN);
            if (previousKind == null) continue;
            if (previousKind == ClassInitializationSupport.InitKind.EAGER) {
                throw UserError.abort("The information that the class should be initialized during image building has already been used, so it is too late to register re-running the class initializer: " + clazz.getTypeName());
            }
            if (!previousKind.isDelayed()) continue;
            throw UserError.abort("Class or a superclass is already registered for delaying the class initializer, so it is too late to register re-running the class initializer: " + clazz.getTypeName());
        }
    }

    @Override
    public void forceInitializeHierarchy(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        if (this.classInitKinds.containsKey(clazz) && this.classInitKinds.get(clazz) == ClassInitializationSupport.InitKind.MUST_DELAY) {
            throw UserError.abort("Class " + clazz.getTypeName() + " is being force initialized, but it is already delayed to runtime.");
        }
        this.ensureClassInitialized(clazz);
        this.classInitKinds.put(clazz, ClassInitializationSupport.InitKind.EAGER);
        this.forceInitializeHierarchy(clazz.getSuperclass());
        this.forceInitializeInterfaces(clazz.getInterfaces());
    }

    private void forceInitializeInterfaces(Class<?>[] interfaces) {
        for (Class<?> iface : interfaces) {
            if (ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(iface))) {
                if (this.classInitKinds.containsKey(iface) && this.classInitKinds.get(iface) == ClassInitializationSupport.InitKind.MUST_DELAY) {
                    throw UserError.abort("Class " + iface.getTypeName() + " is being force initialized, but it is must be delayed to runtime.");
                }
                this.ensureClassInitialized(iface);
                this.classInitKinds.put(iface, ClassInitializationSupport.InitKind.EAGER);
            }
            this.forceInitializeInterfaces(iface.getInterfaces());
        }
    }

    @Override
    public boolean checkDelayedInitialization() {
        for (Map.Entry<Class<?>, ClassInitializationSupport.InitKind> entry : this.classInitKinds.entrySet()) {
            if (!entry.getValue().isDelayed() || UNSAFE.shouldBeInitialized(entry.getKey())) continue;
            throw UserError.abort("Class that is marked for delaying initialization to run time got initialized during image building: " + entry.getKey().getTypeName());
        }
        return true;
    }

    private static void checkEagerInitialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw UserError.abort("Primitive types and array classes are initialized eagerly because initialization is side-effect free. It is not possible (and also not useful) to register them for run time initialization: " + clazz.getTypeName());
        }
    }

    public void eagerClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            this.metaAccess.lookupJavaType(clazz);
            this.forceInitializeHierarchy(clazz);
        }
    }
}

