/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class FeatureHandler {
    private final ArrayList<org.graalvm.nativeimage.hosted.Feature> featureInstances = new ArrayList();
    private final HashSet<Class<?>> registeredFeatures = new HashSet();

    public void forEachFeature(Consumer<org.graalvm.nativeimage.hosted.Feature> consumer) {
        for (org.graalvm.nativeimage.hosted.Feature feature : this.featureInstances) {
            consumer.accept(feature);
        }
    }

    public void forEachGraalFeature(Consumer<GraalFeature> consumer) {
        for (org.graalvm.nativeimage.hosted.Feature feature : this.featureInstances) {
            if (!(feature instanceof GraalFeature)) continue;
            consumer.accept((GraalFeature)feature);
        }
    }

    public void registerFeatures(ImageClassLoader loader, DebugContext debug) {
        FeatureImpl.IsInConfigurationAccessImpl access = new FeatureImpl.IsInConfigurationAccessImpl(this, loader, debug);
        for (Class<?> automaticFeature : loader.findAnnotatedClasses(AutomaticFeature.class)) {
            this.registerFeature(automaticFeature, access);
        }
        for (String featureName : OptionUtils.flatten(",", Options.Features.getValue())) {
            try {
                this.registerFeature(Class.forName(featureName, true, loader.getClassLoader()), access);
            }
            catch (ClassNotFoundException e) {
                throw UserError.abort("feature " + featureName + " class not found on the classpath. Ensure that the name is correct and that the class is on the classpath.");
            }
        }
    }

    private void registerFeature(Class<?> featureClass, FeatureImpl.IsInConfigurationAccessImpl access) {
        org.graalvm.nativeimage.hosted.Feature feature;
        if (!org.graalvm.nativeimage.hosted.Feature.class.isAssignableFrom(featureClass)) {
            throw UserError.abort("Class does not implement " + org.graalvm.nativeimage.hosted.Feature.class.getName() + ": " + featureClass.getName());
        }
        if (this.registeredFeatures.contains(featureClass)) {
            return;
        }
        this.registeredFeatures.add(featureClass);
        try {
            Constructor<?> constructor = featureClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            feature = (org.graalvm.nativeimage.hosted.Feature)constructor.newInstance(new Object[0]);
            if (!feature.isInConfiguration((Feature.IsInConfigurationAccess)access)) {
                return;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        ImageSingletons.add(feature.getClass(), (Object)feature);
        for (Class requiredFeatureClass : feature.getRequiredFeatures()) {
            this.registerFeature(requiredFeatureClass, access);
        }
        this.featureInstances.add(feature instanceof Feature ? new WrappedDeprecatedFeature((Feature)feature) : feature);
    }

    private class WrappedDeprecatedFeature
    implements org.graalvm.nativeimage.hosted.Feature {
        private Feature feature;

        WrappedDeprecatedFeature(Feature feature) {
            this.feature = feature;
        }

        public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
            return this.feature.isInConfiguration((Feature.IsInConfigurationAccess)access);
        }

        public List<Class<? extends org.graalvm.nativeimage.hosted.Feature>> getRequiredFeatures() {
            return this.feature.getRequiredFeatures();
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            this.feature.afterRegistration((Feature.AfterRegistrationAccess)access);
        }

        public void duringSetup(Feature.DuringSetupAccess access) {
            this.feature.duringSetup((Feature.DuringSetupAccess)access);
        }

        public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
            this.feature.beforeAnalysis((Feature.BeforeAnalysisAccess)access);
        }

        public void duringAnalysis(Feature.DuringAnalysisAccess access) {
            this.feature.duringAnalysis((Feature.DuringAnalysisAccess)access);
        }

        public void afterAnalysis(Feature.AfterAnalysisAccess access) {
            this.feature.afterAnalysis((Feature.AfterAnalysisAccess)access);
        }

        public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
            this.feature.onAnalysisExit((Feature.OnAnalysisExitAccess)access);
        }

        public void beforeCompilation(Feature.BeforeCompilationAccess access) {
            this.feature.beforeCompilation((Feature.BeforeCompilationAccess)access);
        }

        public void afterCompilation(Feature.AfterCompilationAccess access) {
            this.feature.afterCompilation((Feature.AfterCompilationAccess)access);
        }

        public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
            this.feature.afterHeapLayout((Feature.AfterHeapLayoutAccess)access);
        }

        public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
            this.feature.beforeImageWrite((Feature.BeforeImageWriteAccess)access);
        }

        public void afterImageWrite(Feature.AfterImageWriteAccess access) {
            this.feature.afterImageWrite((Feature.AfterImageWriteAccess)access);
        }
    }

    public static class Options {
        @APIOption(name="features")
        @Option(help={"A comma-separated list of fully qualified Feature implementation classes"})
        public static final HostedOptionKey<String[]> Features = new HostedOptionKey<Object>(null);
    }
}

