/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class ClassValueFeature
implements Feature {
    private final Map<ClassValue<?>, Map<Class<?>, Object>> values = new ConcurrentHashMap();
    private static final Field IDENTITY;
    private static final Field CLASS_VALUE_MAP;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        JavaLangSubstitutions.ClassValueSupport support = new JavaLangSubstitutions.ClassValueSupport(this.values);
        ImageSingletons.add(JavaLangSubstitutions.ClassValueSupport.class, (Object)support);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::processObject);
    }

    private Object processObject(Object obj) {
        if (obj instanceof ClassValue) {
            this.values.putIfAbsent((ClassValue)obj, new ConcurrentHashMap());
        }
        return obj;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl impl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        List types = impl.getUniverse().getTypes();
        for (AnalysisType t : types) {
            if (!t.isInstantiated() && !t.isInTypeCheck()) continue;
            Class clazz = t.getJavaClass();
            for (Map.Entry<ClassValue<?>, Map<Class<?>, Object>> e : this.values.entrySet()) {
                ClassValue<?> v = e.getKey();
                Map<Class<?>, Object> m = e.getValue();
                if (m.containsKey(clazz) || !ClassValueFeature.hasValue(v, clazz)) continue;
                m.put(clazz, v.get(clazz));
                access.requireAnalysisIteration();
            }
        }
    }

    private static boolean hasValue(ClassValue<?> v, Class<?> c) {
        try {
            Map map = (Map)CLASS_VALUE_MAP.get(c);
            Object id = IDENTITY.get(v);
            boolean res = map != null && map.containsKey(id);
            return res;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        try {
            IDENTITY = ClassValue.class.getDeclaredField("identity");
            IDENTITY.setAccessible(true);
            CLASS_VALUE_MAP = Class.class.getDeclaredField("classValueMap");
            CLASS_VALUE_MAP.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

