/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jni.JNIRuntimeAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="nio")
class WindowsJavaNIOSubstituteFeature
implements Feature {
    WindowsJavaNIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.nio.fs.WindowsNativeDispatcher")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.nio.fs.WindowsSecurity")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.nio.ch.ServerSocketChannelImpl")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.nio.ch.IOUtil")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.nio.ch.FileChannelImpl")});
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstFile"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstFile").getDeclaredField("handle"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstFile").getDeclaredField("name"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstFile").getDeclaredField("attributes"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstStream"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstStream").getDeclaredField("handle"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$FirstStream").getDeclaredField("name"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$VolumeInformation"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$VolumeInformation").getDeclaredField("fileSystemName"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$VolumeInformation").getDeclaredField("volumeName"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$VolumeInformation").getDeclaredField("volumeSerialNumber"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$VolumeInformation").getDeclaredField("flags"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace").getDeclaredField("freeBytesAvailable"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace").getDeclaredField("totalNumberOfBytes"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace").getDeclaredField("totalNumberOfFreeBytes"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$Account"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$Account").getDeclaredField("domain"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$Account").getDeclaredField("name"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$Account").getDeclaredField("use"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$AclInformation"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$AclInformation").getDeclaredField("aceCount"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$CompletionStatus"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$CompletionStatus").getDeclaredField("error"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$CompletionStatus").getDeclaredField("bytesTransferred"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$CompletionStatus").getDeclaredField("completionKey"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$BackupResult"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$BackupResult").getDeclaredField("bytesTransferred"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsNativeDispatcher$BackupResult").getDeclaredField("context"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileChannelImpl"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.ch.FileChannelImpl").getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Exception"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Exception").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsException"));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsException").getDeclaredConstructor(Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("sun.nio.fs.WindowsException").getDeclaredConstructor(String.class));
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            VMError.shouldNotReachHere("JNIRuntimeAccess.register failed: ", e);
        }
    }
}

