/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.WordFactory;

public abstract class VMOperation
extends VMOperationControl.AllocationFreeStack.Element<VMOperation> {
    private final String name;
    private final CallerEffect callerEffect;
    private final SystemEffect systemEffect;
    private IsolateThread queuingVMThread;
    private IsolateThread executingVMThread;

    protected VMOperation(String name, CallerEffect callerEffect, SystemEffect systemEffect) {
        this.name = name;
        this.callerEffect = callerEffect;
        this.systemEffect = systemEffect;
        assert (callerEffect == CallerEffect.BLOCKS_CALLER) : "Only blocking calls are implemented";
    }

    public final void enqueue() {
        try {
            StackOverflowCheck.singleton().makeYellowZoneAvailable();
            if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                this.execute();
            } else {
                this.setQueuingVMThread(CurrentIsolate.getCurrentThread());
                VMOperationControl.enqueue(this);
                this.setQueuingVMThread((IsolateThread)WordFactory.nullPointer());
            }
        }
        catch (Safepoint.SafepointException se) {
            throw VMOperation.rethrow(se.inner);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static void enqueueBlockingSafepoint(String name, SubstrateUtil.Thunk thunk) {
        ThunkOperation vmOperation = new ThunkOperation(name, CallerEffect.BLOCKS_CALLER, SystemEffect.CAUSES_SAFEPOINT, thunk);
        vmOperation.enqueue();
    }

    public static void enqueueBlockingNoSafepoint(String name, SubstrateUtil.Thunk thunk) {
        ThunkOperation vmOperation = new ThunkOperation(name, CallerEffect.BLOCKS_CALLER, SystemEffect.DOES_NOT_CAUSE_SAFEPOINT, thunk);
        vmOperation.enqueue();
    }

    protected final void execute() {
        try {
            this.operateUnderIndicator();
        }
        catch (Throwable t) {
            Log.log().string("[VMOperation.execute caught: ").string(t.getClass().getName()).string("]").newline();
            throw VMError.shouldNotReachHere(t);
        }
    }

    private void operateUnderIndicator() {
        VMOperationControl control = (VMOperationControl)ImageSingletons.lookup(VMOperationControl.class);
        VMOperation previousInProgress = control.getInProgress();
        try {
            this.executingVMThread = CurrentIsolate.getCurrentThread();
            control.setInProgress(this);
            this.operate();
        }
        finally {
            control.setInProgress(previousInProgress);
            this.executingVMThread = (IsolateThread)WordFactory.nullPointer();
        }
    }

    public static boolean isInProgress() {
        VMOperation cur = ((VMOperationControl)ImageSingletons.lookup(VMOperationControl.class)).getInProgress();
        return cur != null && cur.executingVMThread == CurrentIsolate.getCurrentThread();
    }

    public static void guaranteeInProgress(String message) {
        if (!VMOperation.isInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    public static void guaranteeNotInProgress(String message) {
        if (VMOperation.isInProgress()) {
            throw VMError.shouldNotReachHere(message);
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Whitelisted because some operations may allocate.")
    protected abstract void operate();

    protected final String getName() {
        return this.name;
    }

    final boolean getBlocksCaller() {
        return this.callerEffect == CallerEffect.BLOCKS_CALLER;
    }

    final boolean getCausesSafepoint() {
        return this.systemEffect == SystemEffect.CAUSES_SAFEPOINT;
    }

    protected final IsolateThread getQueuingVMThread() {
        return this.queuingVMThread;
    }

    private void setQueuingVMThread(IsolateThread vmThread) {
        this.queuingVMThread = vmThread;
    }

    final IsolateThread getExecutingVMThread() {
        return this.executingVMThread;
    }

    public static class ThunkOperation
    extends VMOperation {
        private SubstrateUtil.Thunk thunk;

        ThunkOperation(String name, CallerEffect callerEffect, SystemEffect systemEffect, SubstrateUtil.Thunk thunk) {
            super(name, callerEffect, systemEffect);
            this.thunk = thunk;
        }

        @Override
        public void operate() {
            this.thunk.invoke();
        }
    }

    public static enum SystemEffect {
        DOES_NOT_CAUSE_SAFEPOINT,
        CAUSES_SAFEPOINT;

    }

    public static enum CallerEffect {
        DOES_NOT_BLOCK_CALLER,
        BLOCKS_CALLER;

    }
}

