/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.Package_jdk_internal_misc;
import com.oracle.svm.core.thread.UnsafeParkSupport;
import com.oracle.svm.core.util.TimeUtils;

@TargetClass(classNameProvider=Package_jdk_internal_misc.class, className="Unsafe")
final class Target_Unsafe_JavaThreads {
    Target_Unsafe_JavaThreads() {
    }

    @Substitute
    private void park(boolean isAbsolute, long time) {
        if (!isAbsolute && time == 0L) {
            UnsafeParkSupport.park();
        } else {
            long delayNanos = TimeUtils.delayNanos(isAbsolute, time);
            UnsafeParkSupport.park(delayNanos);
        }
    }

    @Substitute
    private void unpark(Object threadObj) {
        if (threadObj == null) {
            throw new NullPointerException("Unsafe.unpark(thread == null)");
        }
        if (!(threadObj instanceof Thread)) {
            throw new IllegalArgumentException("Unsafe.unpark(!(thread instanceof Thread))");
        }
        Thread thread = (Thread)threadObj;
        UnsafeParkSupport.unpark(thread);
    }
}

