/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Pwd;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
@TargetClass(className="com.sun.security.auth.module.UnixSystem")
final class Target_com_sun_security_auth_module_UnixSystem {
    @Alias
    String username;
    @Alias
    long uid;
    @Alias
    long gid;
    @Alias
    long[] groups;

    @Substitute
    Target_com_sun_security_auth_module_UnixSystem() {
        this.getUnixInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    void getUnixInfo() {
        int realUid = Unistd.getuid();
        Word pwsize = (Word)WordFactory.signed((long)Unistd.sysconf(Unistd._SC_GETPW_R_SIZE_MAX()));
        if (pwsize.lessThan(0)) {
            pwsize = (Word)WordFactory.signed((int)1024);
        }
        CCharPointer pwbuf = (CCharPointer)LibC.malloc((UnsignedWord)pwsize);
        try {
            int result;
            Pwd.passwd pwent = (Pwd.passwd)StackValue.get(Pwd.passwd.class);
            Pwd.passwdPointer p = (Pwd.passwdPointer)StackValue.get(Pwd.passwdPointer.class);
            do {
                if (pwbuf.isNull()) {
                    throw new OutOfMemoryError("Native heap");
                }
                p.write(WordFactory.nullPointer());
                result = Pwd.getpwuid_r(realUid, pwent, pwbuf, (UnsignedWord)pwsize, p);
                if (result == Errno.ERANGE()) {
                    pwsize = pwsize.add(pwsize);
                    pwbuf = (CCharPointer)LibC.realloc((PointerBase)pwbuf, (UnsignedWord)pwsize);
                    continue;
                }
                if (result >= 0 || result == Errno.EINTR()) continue;
                throw new RuntimeException("getpwuid_r error: " + Errno.errno());
            } while (result != 0);
            this.uid = pwent.pw_uid();
            this.gid = pwent.pw_gid();
            this.username = CTypeConversion.toJavaString((CCharPointer)pwent.pw_name());
        }
        finally {
            LibC.free((PointerBase)pwbuf);
        }
        int ngroups = Unistd.getgroups(0, (CIntPointer)WordFactory.nullPointer());
        int[] groupIds = new int[ngroups];
        try (PinnedObject pinnedGroupIds = PinnedObject.create((Object)groupIds);){
            ngroups = Unistd.getgroups(groupIds.length, (CIntPointer)pinnedGroupIds.addressOfArrayElement(0));
        }
        this.groups = new long[ngroups];
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = groupIds[i];
        }
    }
}

