/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;

@Repeatable(value=List.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface APIOption {
    public String name();

    public String customHelp() default "";

    public APIOptionKind kind() default APIOptionKind.Default;

    public String[] defaultValue() default {};

    public String[] fixedValue() default {};

    public Class<? extends Function<Object, Object>>[] valueTransformer() default {DefaultTransformer.class};

    public static class DefaultTransformer
    implements Function<Object, Object> {
        @Override
        public Object apply(Object o) {
            return o;
        }
    }

    public static class Utils {
        public static String name(APIOption annotation) {
            if (annotation.name().startsWith("-")) {
                return annotation.name();
            }
            return "--" + annotation.name();
        }
    }

    public static enum APIOptionKind {
        Default,
        Negated,
        Paths;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface List {
        public APIOption[] value();
    }
}

