/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.SpaceVerifierImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public class YoungGeneration
extends Generation {
    private final Space space;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    YoungGeneration(String name) {
        this(name, new Space("youngSpace", true));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private YoungGeneration(String name, Space space) {
        super(name);
        this.space = space;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        ThreadLocalAllocation.tearDown();
        this.space.tearDown();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        ThreadLocalAllocation.disableThreadLocalAllocation();
        return this.getSpace().walkObjects(visitor);
    }

    @Override
    public Log report(Log log, boolean traceHeapChunks) {
        log.string("[Young generation: ").indent(true);
        this.getSpace().report(log, traceHeapChunks);
        log.redent(false).string("]");
        return log;
    }

    public final Space getSpace() {
        return this.space;
    }

    boolean isYoungSpace(Space thatSpace) {
        return this.getSpace() == thatSpace;
    }

    @Override
    protected Object promoteObject(Object original, Pointer objRef, int innerOffset, boolean compressed) {
        throw VMError.shouldNotReachHere("Can not promote to a YoungGeneration.");
    }

    void releaseSpaces() {
        this.getSpace().release();
    }

    @Override
    protected boolean isValidSpace(Space thatSpace) {
        return this.isYoungSpace(thatSpace);
    }

    @Override
    protected boolean verify(HeapVerifier.Occasion occasion) {
        boolean result = true;
        HeapImpl heap = HeapImpl.getHeapImpl();
        HeapVerifierImpl heapVerifier = heap.getHeapVerifierImpl();
        SpaceVerifierImpl spaceVerifier = heapVerifier.getSpaceVerifierImpl();
        spaceVerifier.initialize(this.getSpace());
        if (occasion.equals((Object)HeapVerifier.Occasion.AFTER_COLLECTION)) {
            if (spaceVerifier.containsChunks()) {
                result = false;
                heapVerifier.getWitnessLog().string("[YoungGeneration.verify:").string("  young space contains chunks after collection").string("]").newline();
            }
        } else if (!spaceVerifier.verify()) {
            result = false;
            heapVerifier.getWitnessLog().string("[YoungGeneration.verify:").string("  young space fails to verify").string("]").newline();
        }
        return result;
    }

    boolean slowlyFindPointer(Pointer p) {
        return HeapVerifierImpl.slowlyFindPointerInSpace(this.getSpace(), p, HeapVerifierImpl.ChunkLimit.top);
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        return this.getSpace().walkHeapChunks(visitor);
    }
}

