/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class GreyToBlackObjRefVisitor
implements ObjectReferenceVisitor {
    protected final Counters counters = Options.GreyToBlackObjRefDemographics.getValue() != false ? RealCounters.factory() : NoopCounters.factory();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static GreyToBlackObjRefVisitor factory() {
        return new GreyToBlackObjRefVisitor();
    }

    @Override
    public boolean visitObjectReference(Pointer objRef, boolean compressed) {
        return this.visitObjectReferenceInline(objRef, 0, compressed);
    }

    @Override
    @AlwaysInline(value="GC performance")
    public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed) {
        assert (innerOffset >= 0);
        this.getCounters().noteObjRef();
        Log trace = Log.noopLog().string("[GreyToBlackObjRefVisitor.visitObjectReferenceInline:").string("  objRef: ").hex((WordBase)objRef);
        if (objRef.isNull()) {
            this.getCounters().noteNullObjRef();
            trace.string(" null objRef ").hex((WordBase)objRef).string("]").newline();
            return true;
        }
        Word offsetP = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        assert (offsetP.isNonNull() || innerOffset == 0);
        Pointer p = offsetP.subtract(innerOffset);
        trace.string("  p: ").hex((WordBase)p);
        if (p.isNull()) {
            this.getCounters().noteNullReferent();
            trace.string(" null").string("]").newline();
            return true;
        }
        UnsignedWord header = ObjectHeader.readHeaderFromPointer(p);
        ObjectHeader ohi = HeapImpl.getHeapImpl().getObjectHeader();
        if (ohi.isForwardedHeader(header)) {
            this.getCounters().noteForwardedReferent();
            trace.string("  forwards to ");
            Object obj = ohi.getForwardedObject(p);
            Object offsetObj = innerOffset == 0 ? obj : Word.objectToUntrackedPointer((Object)obj).add(innerOffset).toObject();
            ReferenceAccess.singleton().writeObjectAt(objRef, offsetObj, compressed);
            trace.object(obj);
            if (trace.isEnabled()) {
                trace.string("  objectHeader: ").string(ohi.toStringFromObject(obj)).string("]").newline();
            }
            return true;
        }
        Object obj = p.toObject();
        assert ((long)innerOffset < LayoutEncoding.getSizeFromObject(obj).rawValue());
        if (ohi.isNonHeapAllocatedHeader(header)) {
            this.getCounters().noteNonHeapReferent();
            trace.string("  Non-heap obj: ").object(obj);
            if (trace.isEnabled()) {
                trace.string("  objectHeader: ").string(ohi.toStringFromObject(obj)).string("]").newline();
            }
            return true;
        }
        trace.string(" ").object(obj);
        if (trace.isEnabled()) {
            trace.string("  objectHeader: ").string(ohi.toStringFromObject(obj)).newline();
        }
        Object copy = HeapImpl.getHeapImpl().promoteObject(obj, objRef, innerOffset, compressed);
        trace.string("  copy: ").object(copy);
        if (trace.isEnabled()) {
            trace.string("  objectHeader: ").string(ohi.toStringFromObject(copy));
        }
        if (copy != obj) {
            this.getCounters().noteCopiedReferent();
            trace.string(" updating objRef: ").hex((WordBase)objRef).string(" with copy: ").object(copy);
            Object offsetCopy = innerOffset == 0 ? copy : Word.objectToUntrackedPointer((Object)copy).add(innerOffset).toObject();
            ReferenceAccess.singleton().writeObjectAt(objRef, offsetCopy, compressed);
        } else {
            this.getCounters().noteUnmodifiedReference();
        }
        trace.string("]").newline();
        return true;
    }

    protected Counters getCounters() {
        return this.counters;
    }

    public Counters openCounters() {
        return this.getCounters().open();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GreyToBlackObjRefVisitor() {
    }

    public static class NoopCounters
    implements Counters {
        public static NoopCounters factory() {
            return new NoopCounters();
        }

        @Override
        public NoopCounters open() {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void noteObjRef() {
        }

        @Override
        public void noteNullObjRef() {
        }

        @Override
        public void noteNullReferent() {
        }

        @Override
        public void noteForwardedReferent() {
        }

        @Override
        public void noteNonHeapReferent() {
        }

        @Override
        public void noteCopiedReferent() {
        }

        @Override
        public void noteUnmodifiedReference() {
        }

        @Override
        public void toLog() {
        }

        @Override
        public void reset() {
        }

        protected NoopCounters() {
        }
    }

    public static class RealCounters
    implements Counters {
        protected long objRef;
        protected long nullObjRef;
        protected long nullReferent;
        protected long forwardedReferent;
        protected long nonHeapReferent;
        protected long copiedReferent;
        protected long unmodifiedReference;
        protected boolean isOpened;

        public static RealCounters factory() {
            return new RealCounters();
        }

        @Override
        public RealCounters open() {
            this.reset();
            this.isOpened = true;
            return this;
        }

        @Override
        public void close() {
            this.toLog();
            this.reset();
        }

        @Override
        public boolean isOpen() {
            return this.isOpened;
        }

        @Override
        public void noteObjRef() {
            ++this.objRef;
        }

        @Override
        public void noteNullObjRef() {
            ++this.nullObjRef;
        }

        @Override
        public void noteNullReferent() {
            ++this.nullReferent;
        }

        @Override
        public void noteForwardedReferent() {
            ++this.forwardedReferent;
        }

        @Override
        public void noteNonHeapReferent() {
            ++this.nonHeapReferent;
        }

        @Override
        public void noteCopiedReferent() {
            ++this.copiedReferent;
        }

        @Override
        public void noteUnmodifiedReference() {
            ++this.unmodifiedReference;
        }

        @Override
        public void toLog() {
            Log log = Log.log();
            log.string("[GreyToBlackObjRefVisitor.counters:");
            log.string("  objRef: ").signed(this.objRef);
            log.string("  nullObjRef: ").signed(this.nullObjRef);
            log.string("  nullReferent: ").signed(this.nullReferent);
            log.string("  forwardedReferent: ").signed(this.forwardedReferent);
            log.string("  nonHeapReferent: ").signed(this.nonHeapReferent);
            log.string("  copiedReferent: ").signed(this.copiedReferent);
            log.string("  unmodifiedReference: ").signed(this.unmodifiedReference);
            log.string("]").newline();
        }

        @Override
        public void reset() {
            this.objRef = 0L;
            this.nullObjRef = 0L;
            this.nullReferent = 0L;
            this.forwardedReferent = 0L;
            this.nonHeapReferent = 0L;
            this.copiedReferent = 0L;
            this.unmodifiedReference = 0L;
            this.isOpened = false;
        }

        protected RealCounters() {
            this.reset();
        }
    }

    public static interface Counters
    extends AutoCloseable {
        public Counters open();

        @Override
        public void close();

        public boolean isOpen();

        public void noteObjRef();

        public void noteNullObjRef();

        public void noteNullReferent();

        public void noteForwardedReferent();

        public void noteNonHeapReferent();

        public void noteCopiedReferent();

        public void noteUnmodifiedReference();

        public void toLog();

        public void reset();
    }

    public static class Options {
        @Option(help={"Develop demographics of the object references visited."})
        public static final HostedOptionKey<Boolean> GreyToBlackObjRefDemographics = new HostedOptionKey<Boolean>(false);
    }
}

