/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;

public class SubstrateSpeculationLog
implements SpeculationLog {
    private final ConcurrentMap<SpeculationLog.SpeculationReason, Boolean> failedSpeculations = new ConcurrentHashMap<SpeculationLog.SpeculationReason, Boolean>();

    public void addFailedSpeculation(SpeculationLog.SpeculationReason speculation) {
        this.failedSpeculations.put(speculation, Boolean.TRUE);
    }

    public void collectFailedSpeculations() {
    }

    public boolean maySpeculate(SpeculationLog.SpeculationReason reason) {
        return !this.failedSpeculations.containsKey(reason);
    }

    public SpeculationLog.Speculation speculate(SpeculationLog.SpeculationReason reason) {
        if (!this.maySpeculate(reason)) {
            throw new IllegalArgumentException("Cannot make speculation with reason " + reason + " as it is known to fail");
        }
        return new SubstrateSpeculation(reason);
    }

    public boolean hasSpeculations() {
        return true;
    }

    public SpeculationLog.Speculation lookupSpeculation(JavaConstant constant) {
        return new SubstrateSpeculation((SpeculationLog.SpeculationReason)KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)constant), Object.class));
    }

    public static final class SubstrateSpeculation
    extends SpeculationLog.Speculation {
        public SubstrateSpeculation(SpeculationLog.SpeculationReason reason) {
            super(reason);
        }
    }
}

