// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: NativeImageOptions.java
package com.oracle.svm.hosted;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class NativeImageOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AllowFoldMethods": {
            return OptionDescriptor.create(
                /*name*/ "AllowFoldMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow MethodTypeFlow to see @Fold methods",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "AllowFoldMethods",
                /*option*/ NativeImageOptions.AllowFoldMethods);
        }
        case "AllowIncompleteClasspath": {
            return OptionDescriptor.create(
                /*name*/ "AllowIncompleteClasspath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow image building with an incomplete class path: report type resolution errors at run time when they are accessed the first time, instead of during image building",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "AllowIncompleteClasspath",
                /*option*/ NativeImageOptions.AllowIncompleteClasspath);
        }
        case "CPUFeatures": {
            return OptionDescriptor.create(
                /*name*/ "CPUFeatures",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String[].class,
                /*help*/ "Comma separated list of CPU features that will be used for image generation on the AMD64 platform. Features SSE and SSE2 are enabled by default. Other available features are: CX8, CMOV, FXSR, HT, MMX, AMD_3DNOW_PREFETCH, SSE3, SSSE3, SSE4A, SSE4_1, SSE4_2, POPCNT, LZCNT, TSC, TSCINV, AVX, AVX2, AES, ERMS, CLMUL, BMI1, BMI2, RTM, ADX, AVX512F, AVX512DQ, AVX512PF, AVX512ER, AVX512CD, AVX512BW",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "CPUFeatures",
                /*option*/ NativeImageOptions.CPUFeatures);
        }
        case "CStandard": {
            return OptionDescriptor.create(
                /*name*/ "CStandard",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "C standard to use in header files. Possible values are: [C89, C99, C11]",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "CStandard",
                /*option*/ NativeImageOptions.CStandard);
        }
        case "Class": {
            return OptionDescriptor.create(
                /*name*/ "Class",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Class containing the default entry point method. Optional if --shared is used.",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "Class",
                /*option*/ NativeImageOptions.Class);
        }
        case "ExitAfterAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "ExitAfterAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit after analysis",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ExitAfterAnalysis",
                /*option*/ NativeImageOptions.ExitAfterAnalysis);
        }
        case "Kind": {
            return OptionDescriptor.create(
                /*name*/ "Kind",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Generate a SHARED_LIBRARY, EXECUTABLE or STATIC_EXECUTABLE image",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "Kind",
                /*option*/ NativeImageOptions.Kind);
        }
        case "MachODebugInfoTesting": {
            return OptionDescriptor.create(
                /*name*/ "MachODebugInfoTesting",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Test Mach-O debuginfo generation",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "MachODebugInfoTesting",
                /*option*/ NativeImageOptions.MachODebugInfoTesting);
        }
        case "MaxReachableTypes": {
            return OptionDescriptor.create(
                /*name*/ "MaxReachableTypes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of types allowed in the image. Used for tests where small number of types in necessary.",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "MaxReachableTypes",
                /*option*/ NativeImageOptions.MaxReachableTypes);
        }
        case "Method": {
            return OptionDescriptor.create(
                /*name*/ "Method",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the main entry point method. Optional if --shared is used.",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "Method",
                /*option*/ NativeImageOptions.Method);
        }
        case "Name": {
            return OptionDescriptor.create(
                /*name*/ "Name",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the output file to be generated",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "Name",
                /*option*/ NativeImageOptions.Name);
        }
        case "NativeArchitecture": {
            return OptionDescriptor.create(
                /*name*/ "NativeArchitecture",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Overrides CPUFeatures and uses the native architecture, i.e., the architecture of a machine that builds an image. NativeArchitecture takes precedence over CPUFeatures",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "NativeArchitecture",
                /*option*/ NativeImageOptions.NativeArchitecture);
        }
        case "NumberOfAnalysisThreads": {
            return OptionDescriptor.create(
                /*name*/ "NumberOfAnalysisThreads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The number of threads to use for analysis during native image generation. The number must be smaller than the NumberOfThreads.",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "NumberOfAnalysisThreads",
                /*option*/ NativeImageOptions.NumberOfAnalysisThreads);
        }
        case "NumberOfThreads": {
            return OptionDescriptor.create(
                /*name*/ "NumberOfThreads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of threads to use concurrently during native image generation.",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "NumberOfThreads",
                /*option*/ NativeImageOptions.NumberOfThreads);
        }
        case "PageSize": {
            return OptionDescriptor.create(
                /*name*/ "PageSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define PageSize of a machine that runs the image. The default = 0 (== same as host machine page size)",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PageSize",
                /*option*/ NativeImageOptions.PageSize);
        }
        case "PrintAOTCompilation": {
            return OptionDescriptor.create(
                /*name*/ "PrintAOTCompilation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print logging information during compilation",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintAOTCompilation",
                /*option*/ NativeImageOptions.PrintAOTCompilation);
        }
        case "PrintFeatures": {
            return OptionDescriptor.create(
                /*name*/ "PrintFeatures",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print features-specific information",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintFeatures",
                /*option*/ NativeImageOptions.PrintFeatures);
        }
        case "PrintHeapHistogram": {
            return OptionDescriptor.create(
                /*name*/ "PrintHeapHistogram",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print class statistics of native image heap",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintHeapHistogram",
                /*option*/ NativeImageOptions.PrintHeapHistogram);
        }
        case "PrintImageElementSizes": {
            return OptionDescriptor.create(
                /*name*/ "PrintImageElementSizes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the sizes of the elements of the built image",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintImageElementSizes",
                /*option*/ NativeImageOptions.PrintImageElementSizes);
        }
        case "PrintImageHeapPartitionSizes": {
            return OptionDescriptor.create(
                /*name*/ "PrintImageHeapPartitionSizes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the sizes of the native image heap as the image is built",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintImageHeapPartitionSizes",
                /*option*/ NativeImageOptions.PrintImageHeapPartitionSizes);
        }
        case "PrintMethodHistogram": {
            return OptionDescriptor.create(
                /*name*/ "PrintMethodHistogram",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print statistics of methods in native image heap",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintMethodHistogram",
                /*option*/ NativeImageOptions.PrintMethodHistogram);
        }
        case "PrintUniverse": {
            return OptionDescriptor.create(
                /*name*/ "PrintUniverse",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print information about classes, methods, and fields that are present in the native image",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "PrintUniverse",
                /*option*/ NativeImageOptions.PrintUniverse);
        }
        case "ReportExceptionStackTraces": {
            return OptionDescriptor.create(
                /*name*/ "ReportExceptionStackTraces",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show exception stack traces for exceptions during image building.)",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ReportExceptionStackTraces",
                /*option*/ NativeImageOptions.ReportExceptionStackTraces);
        }
        case "ReportUnsafeOffsetWarnings": {
            return OptionDescriptor.create(
                /*name*/ "ReportUnsafeOffsetWarnings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print unsafe operation offset warnings.)",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ReportUnsafeOffsetWarnings",
                /*option*/ NativeImageOptions.ReportUnsafeOffsetWarnings);
        }
        case "ReportUnsupportedElementsAtRuntime": {
            return OptionDescriptor.create(
                /*name*/ "ReportUnsupportedElementsAtRuntime",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report usage of unsupported methods and fields at run time when they are accessed the first time, instead of as an error during image building",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ReportUnsupportedElementsAtRuntime",
                /*option*/ NativeImageOptions.ReportUnsupportedElementsAtRuntime);
        }
        case "ReportUnsupportedFeaturesCause": {
            return OptionDescriptor.create(
                /*name*/ "ReportUnsupportedFeaturesCause",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report the original exception cause for unsupported features.",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ReportUnsupportedFeaturesCause",
                /*option*/ NativeImageOptions.ReportUnsupportedFeaturesCause);
        }
        case "ReturnAfterAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "ReturnAfterAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Return after analysis",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ReturnAfterAnalysis",
                /*option*/ NativeImageOptions.ReturnAfterAnalysis);
        }
        case "SuppressStderr": {
            return OptionDescriptor.create(
                /*name*/ "SuppressStderr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Suppress console error output for unittests",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "SuppressStderr",
                /*option*/ NativeImageOptions.SuppressStderr);
        }
        case "SuppressStdout": {
            return OptionDescriptor.create(
                /*name*/ "SuppressStdout",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Suppress console normal output for unittests",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "SuppressStdout",
                /*option*/ NativeImageOptions.SuppressStdout);
        }
        case "TempDirectory": {
            return OptionDescriptor.create(
                /*name*/ "TempDirectory",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Directory for temporary files generated during native image generation. If this option is specified, the temporary files are not deleted so that you can inspect them after native image generation",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "TempDirectory",
                /*option*/ NativeImageOptions.TempDirectory);
        }
        case "ThrowUnsafeOffsetErrors": {
            return OptionDescriptor.create(
                /*name*/ "ThrowUnsafeOffsetErrors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Throw unsafe operation offset errors.)",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "ThrowUnsafeOffsetErrors",
                /*option*/ NativeImageOptions.ThrowUnsafeOffsetErrors);
        }
        case "UnsafeOffsetWarningsAreFatal": {
            return OptionDescriptor.create(
                /*name*/ "UnsafeOffsetWarningsAreFatal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print unsafe operation offset warnings.)",
                /*declaringClass*/ NativeImageOptions.class,
                /*fieldName*/ "UnsafeOffsetWarningsAreFatal",
                /*option*/ NativeImageOptions.UnsafeOffsetWarningsAreFatal);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 32;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllowFoldMethods");
                    case 1: return get("AllowIncompleteClasspath");
                    case 2: return get("CPUFeatures");
                    case 3: return get("CStandard");
                    case 4: return get("Class");
                    case 5: return get("ExitAfterAnalysis");
                    case 6: return get("Kind");
                    case 7: return get("MachODebugInfoTesting");
                    case 8: return get("MaxReachableTypes");
                    case 9: return get("Method");
                    case 10: return get("Name");
                    case 11: return get("NativeArchitecture");
                    case 12: return get("NumberOfAnalysisThreads");
                    case 13: return get("NumberOfThreads");
                    case 14: return get("PageSize");
                    case 15: return get("PrintAOTCompilation");
                    case 16: return get("PrintFeatures");
                    case 17: return get("PrintHeapHistogram");
                    case 18: return get("PrintImageElementSizes");
                    case 19: return get("PrintImageHeapPartitionSizes");
                    case 20: return get("PrintMethodHistogram");
                    case 21: return get("PrintUniverse");
                    case 22: return get("ReportExceptionStackTraces");
                    case 23: return get("ReportUnsafeOffsetWarnings");
                    case 24: return get("ReportUnsupportedElementsAtRuntime");
                    case 25: return get("ReportUnsupportedFeaturesCause");
                    case 26: return get("ReturnAfterAnalysis");
                    case 27: return get("SuppressStderr");
                    case 28: return get("SuppressStdout");
                    case 29: return get("TempDirectory");
                    case 30: return get("ThrowUnsafeOffsetErrors");
                    case 31: return get("UnsafeOffsetWarningsAreFatal");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
