/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.code.AbstractCodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeMethodInfo;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.truffle.api.nodes.RootNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.WordFactory;

public class SubstrateOptimizedCallTarget
extends OptimizedCallTarget
implements SubstrateInstalledCode,
OptimizedAssumptionDependency {
    protected long address;

    public SubstrateOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        super(sourceCallTarget, rootNode);
    }

    @Override
    public SubstrateSpeculationLog getSpeculationLog() {
        return (SubstrateSpeculationLog)super.getSpeculationLog();
    }

    @Override
    public void invalidate() {
        this.invalidate(null, null);
    }

    public CompilableTruffleAST getCompilable() {
        return this;
    }

    public void invalidateCode() {
        CodeInfoTable.invalidateInstalledCode(this);
    }

    @Override
    public boolean isValid() {
        return this.address != 0L;
    }

    public boolean isValidLastTier() {
        long address0 = this.getAddress();
        if (address0 == 0L) {
            return false;
        }
        AbstractCodeInfo codeInfo = CodeInfoTable.lookupCodeInfo((CodePointer)WordFactory.pointer((long)address0));
        if (!(codeInfo instanceof RuntimeMethodInfo)) {
            return false;
        }
        RuntimeMethodInfo runtimeCodeInfo = (RuntimeMethodInfo)codeInfo;
        return runtimeCodeInfo.getTier() == 2;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public long getCodeAddress() {
        return this.getAddress();
    }

    @Override
    public void setAddress(long address, ResolvedJavaMethod method) {
        this.address = address;
    }

    @Override
    public void clearAddress() {
        this.address = 0L;
    }

    public Object doInvoke(Object[] args) {
        long start = this.address;
        if (start != 0L) {
            CallBoundaryFunctionPointer target = (CallBoundaryFunctionPointer)WordFactory.pointer((long)start);
            return KnownIntrinsics.convertUnknownValue(target.invoke(this, args), Object.class);
        }
        return this.callBoundary(args);
    }

    static interface CallBoundaryFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public Object invoke(OptimizedCallTarget var1, Object[] var2);
    }
}

