/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.phases.TrustedInterfaceTypePlugin;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.NoClassInitializationPlugin;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import java.lang.invoke.MethodHandle;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnaryOpLogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.tiers.PhaseContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;

public class IntrinsifyMethodHandlesInvocationPlugin
implements NodePlugin {
    private final Providers originalProviders;
    private final Providers universeProviders;
    private final AnalysisUniverse aUniverse;
    private final HostedUniverse hUniverse;
    private final ClassInitializationPlugin classInitializationPlugin;

    public IntrinsifyMethodHandlesInvocationPlugin(Providers providers, AnalysisUniverse aUniverse, HostedUniverse hUniverse) {
        this.aUniverse = aUniverse;
        this.hUniverse = hUniverse;
        this.universeProviders = providers;
        this.originalProviders = GraalAccess.getOriginalProviders();
        this.classInitializationPlugin = new SubstrateClassInitializationPlugin((SVMHost)aUniverse.hostVM());
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (b.getInvokeKind().isDirect() && (IntrinsifyMethodHandlesInvocationPlugin.hasMethodHandleArgument(args) || IntrinsifyMethodHandlesInvocationPlugin.isVarHandleMethod(method))) {
            this.processInvokeWithMethodHandle(b, this.universeProviders.getReplacements().getDefaultReplacementBytecodeProvider(), method, args);
            return true;
        }
        return false;
    }

    private static boolean hasMethodHandleArgument(ValueNode[] args) {
        for (ValueNode argument : args) {
            if (!argument.isConstant() || argument.getStackKind() != JavaKind.Object || !(SubstrateObjectConstant.asObject((Constant)argument.asJavaConstant()) instanceof MethodHandle)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVarHandleMethod(ResolvedJavaMethod method) {
        return method.getDeclaringClass().toJavaName(true).equals("java.lang.invoke.VarHandleGuards");
    }

    private static void registerInvocationPlugins(InvocationPlugins plugins, BytecodeProvider bytecodeProvider) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.DirectMethodHandle", bytecodeProvider);
        r.register1("ensureInitialized", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.Invokers", bytecodeProvider);
        r.registerOptional1("maybeCustomize", MethodHandle.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode mh) {
                return true;
            }
        });
    }

    private void processInvokeWithMethodHandle(GraphBuilderContext b, BytecodeProvider bytecodeProvider, ResolvedJavaMethod methodHandleMethod, ValueNode[] methodHandleArguments) {
        GraphBuilderConfiguration.Plugins graphBuilderPlugins = new GraphBuilderConfiguration.Plugins(((ReplacementsImpl)this.originalProviders.getReplacements()).getGraphBuilderPlugins());
        IntrinsifyMethodHandlesInvocationPlugin.registerInvocationPlugins(graphBuilderPlugins.getInvocationPlugins(), bytecodeProvider);
        graphBuilderPlugins.prependParameterPlugin((ParameterPlugin)new MethodHandlesParameterPlugin(methodHandleArguments));
        graphBuilderPlugins.clearInlineInvokePlugins();
        graphBuilderPlugins.prependInlineInvokePlugin((InlineInvokePlugin)new MethodHandlesInlineInvokePlugin());
        graphBuilderPlugins.prependNodePlugin((NodePlugin)new MethodHandlePlugin(this.originalProviders.getConstantReflection().getMethodHandleAccess(), false));
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        WordOperationPlugin wordOperationPlugin = new WordOperationPlugin(originalSnippetReflection, new WordTypes(this.originalProviders.getMetaAccess(), FrameAccess.getWordKind()));
        graphBuilderPlugins.appendInlineInvokePlugin((InlineInvokePlugin)wordOperationPlugin);
        graphBuilderPlugins.appendTypePlugin((TypePlugin)wordOperationPlugin);
        graphBuilderPlugins.appendTypePlugin((TypePlugin)new TrustedInterfaceTypePlugin());
        graphBuilderPlugins.appendNodePlugin((NodePlugin)wordOperationPlugin);
        graphBuilderPlugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
        GraphBuilderConfiguration graphBuilderConfig = GraphBuilderConfiguration.getSnippetDefault((GraphBuilderConfiguration.Plugins)graphBuilderPlugins);
        GraphBuilderPhase.Instance graphBuilder = new GraphBuilderPhase.Instance(this.originalProviders.getMetaAccess(), this.originalProviders.getStampProvider(), this.originalProviders.getConstantReflection(), this.originalProviders.getConstantFieldProvider(), graphBuilderConfig, OptimisticOptimizations.NONE, null);
        DebugContext debug = b.getDebug();
        StructuredGraph graph = new StructuredGraph.Builder(b.getOptions(), debug).method(IntrinsifyMethodHandlesInvocationPlugin.toOriginal(methodHandleMethod)).build();
        try (DebugContext.Scope s = debug.scope((Object)"IntrinsifyMethodHandles", (Object)graph);){
            ResolvedJavaMethod resolvedTarget;
            graphBuilder.apply(graph);
            for (PiNode pi : graph.getNodes(PiNode.TYPE)) {
                pi.replaceAndDelete((Node)pi.object());
            }
            for (UnaryOpLogicNode node : graph.getNodes().filter(UnaryOpLogicNode.class).filter(v -> v instanceof IsNullNode || v instanceof InstanceOfNode)) {
                ValueNode value = node.getValue();
                if (!(value instanceof ParameterNode)) continue;
                if (node instanceof InstanceOfNode) {
                    InstanceOfNode inst = (InstanceOfNode)node;
                    TypeReference typeRef = inst.type();
                    value.setStamp((Stamp)new ObjectStamp(typeRef.getType(), typeRef.isExact(), !inst.allowsNull(), false));
                    continue;
                }
                assert (node instanceof IsNullNode);
                ResolvedJavaType type = value.stamp(NodeView.DEFAULT).javaType(this.originalProviders.getMetaAccess());
                value.setStamp((Stamp)new ObjectStamp(type, false, true, false));
            }
            new CanonicalizerPhase().apply(graph, (Object)new PhaseContext(this.originalProviders));
            for (FixedGuardNode guard : graph.getNodes(FixedGuardNode.TYPE)) {
                if (!(guard.next() instanceof AccessFieldNode) || !(guard.condition() instanceof IsNullNode) || !guard.isNegated() || ((IsNullNode)guard.condition()).getValue() != ((AccessFieldNode)guard.next()).object()) continue;
                GraphUtil.removeFixedWithUnusedInputs((FixedWithNextNode)guard);
            }
            debug.dump(5, (Object)graph, "Final intrinisfication graph");
            Node singleFunctionality = null;
            ReturnNode singleReturn = null;
            for (Node node : graph.getNodes()) {
                if (node == graph.start() || node instanceof ParameterNode || node instanceof ConstantNode || node instanceof FrameState || node instanceof Invoke) continue;
                if ((node instanceof MethodCallTargetNode || node instanceof LoadFieldNode || node instanceof StoreFieldNode) && singleFunctionality == null) {
                    singleFunctionality = node;
                    continue;
                }
                if (node instanceof ReturnNode && singleReturn == null) {
                    singleReturn = (ReturnNode)node;
                    continue;
                }
                throw new UnsupportedFeatureException("Invoke with MethodHandle argument could not be reduced to at most a single call: " + methodHandleMethod.format("%H.%n(%p)"));
            }
            if (singleFunctionality instanceof MethodCallTargetNode) {
                MethodCallTargetNode singleCallTarget = (MethodCallTargetNode)singleFunctionality;
                assert (singleReturn.result() == null || singleReturn.result() == singleCallTarget.invoke());
                resolvedTarget = this.lookup(singleCallTarget.targetMethod());
                this.maybeEmitClassInitialization(b, singleCallTarget.invokeKind() == CallTargetNode.InvokeKind.Static, resolvedTarget.getDeclaringClass());
                ValueNode[] replacedArguments = new ValueNode[singleCallTarget.arguments().size()];
                for (int i = 0; i < replacedArguments.length; ++i) {
                    replacedArguments[i] = this.lookup(b, methodHandleArguments, (ValueNode)singleCallTarget.arguments().get(i));
                }
                b.handleReplacedInvoke(singleCallTarget.invokeKind(), resolvedTarget, replacedArguments, false);
            } else if (singleFunctionality instanceof LoadFieldNode) {
                LoadFieldNode fieldLoad = (LoadFieldNode)singleFunctionality;
                resolvedTarget = this.lookup(fieldLoad.field());
                this.maybeEmitClassInitialization(b, resolvedTarget.isStatic(), resolvedTarget.getDeclaringClass());
                b.addPush(b.getInvokeReturnType().getJavaKind(), (ValueNode)LoadFieldNode.create(null, (ValueNode)this.lookup(b, methodHandleArguments, fieldLoad.object()), (ResolvedJavaField)resolvedTarget));
            } else if (singleFunctionality instanceof StoreFieldNode) {
                StoreFieldNode fieldStore = (StoreFieldNode)singleFunctionality;
                resolvedTarget = this.lookup(fieldStore.field());
                this.maybeEmitClassInitialization(b, resolvedTarget.isStatic(), resolvedTarget.getDeclaringClass());
                b.add((ValueNode)new StoreFieldNode(this.lookup(b, methodHandleArguments, fieldStore.object()), (ResolvedJavaField)resolvedTarget, this.lookup(b, methodHandleArguments, fieldStore.value())));
            } else if (singleReturn.result() != null) {
                JavaConstant constantResult = singleReturn.result().asJavaConstant();
                assert (b.getInvokeReturnType().getJavaKind() == constantResult.getJavaKind());
                b.addPush(constantResult.getJavaKind(), (ValueNode)ConstantNode.forConstant((JavaConstant)this.lookup(constantResult), (MetaAccessProvider)this.universeProviders.getMetaAccess()));
            } else assert (b.getInvokeReturnType().getJavaKind() == JavaKind.Void);
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    private void maybeEmitClassInitialization(GraphBuilderContext b, boolean isStatic, ResolvedJavaType declaringClass) {
        if (isStatic) {
            this.classInitializationPlugin.apply(b, declaringClass, () -> ((BytecodeParser)b).getFrameStateBuilder().create(b.bci(), (BytecodeParser)b.getNonIntrinsicAncestor(), false, null, null));
        }
    }

    private ValueNode lookup(GraphBuilderContext b, ValueNode[] methodHandleArguments, ValueNode node) {
        if (node.isConstant()) {
            return ConstantNode.forConstant((JavaConstant)this.lookup(node.asJavaConstant()), (MetaAccessProvider)this.universeProviders.getMetaAccess(), (StructuredGraph)b.getGraph());
        }
        return methodHandleArguments[((ParameterNode)node).index()];
    }

    private ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        Object result = this.aUniverse.lookup((JavaMethod)method);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaMethod)result);
        }
        return result;
    }

    private ResolvedJavaField lookup(ResolvedJavaField field) {
        Object result = this.aUniverse.lookup((JavaField)field);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaField)result);
        }
        return result;
    }

    private static ResolvedJavaMethod toOriginal(ResolvedJavaMethod method) {
        if (method instanceof HostedMethod) {
            return ((HostedMethod)method).wrapped.wrapped;
        }
        return ((AnalysisMethod)method).wrapped;
    }

    private static ResolvedJavaType toOriginal(ResolvedJavaType type) {
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrapped();
        }
        return ((AnalysisType)type).getWrapped();
    }

    private JavaConstant lookup(JavaConstant constant) {
        return this.aUniverse.lookup(constant);
    }

    private JavaConstant toOriginal(JavaConstant constant) {
        return this.aUniverse.toHosted(constant);
    }

    class MethodHandlesInlineInvokePlugin
    implements InlineInvokePlugin {
        MethodHandlesInlineInvokePlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (b.getDepth() > 20) {
                return null;
            }
            String className = method.getDeclaringClass().toJavaName(true);
            if (className.startsWith("java.lang.invoke.VarHandle")) {
                return null;
            }
            if (className.startsWith("java.lang.invoke")) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
            }
            return null;
        }
    }

    class MethodHandlesParameterPlugin
    implements ParameterPlugin {
        private final ValueNode[] methodHandleArguments;

        MethodHandlesParameterPlugin(ValueNode[] methodHandleArguments) {
            this.methodHandleArguments = methodHandleArguments;
        }

        public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
            if (this.methodHandleArguments[index].isConstant()) {
                return ConstantNode.forConstant((JavaConstant)IntrinsifyMethodHandlesInvocationPlugin.this.toOriginal(this.methodHandleArguments[index].asJavaConstant()), (MetaAccessProvider)IntrinsifyMethodHandlesInvocationPlugin.this.originalProviders.getMetaAccess());
            }
            Stamp argStamp = this.methodHandleArguments[index].stamp(NodeView.DEFAULT);
            ResolvedJavaType argType = StampTool.typeOrNull((Stamp)argStamp);
            if (argType != null) {
                TypeReference typeref = TypeReference.createWithoutAssumptions((ResolvedJavaType)IntrinsifyMethodHandlesInvocationPlugin.toOriginal(argType));
                argStamp = StampTool.isPointerNonNull((Stamp)argStamp) ? StampFactory.objectNonNull((TypeReference)typeref) : StampFactory.object((TypeReference)typeref);
            }
            return new ParameterNode(index, StampPair.createSingle((Stamp)argStamp));
        }
    }
}

