/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.HashMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.nativeimage.ImageSingletons;

public class ImplicitExceptionsPlugin
implements NodePlugin {
    private final MetaAccessProvider metaAccess;
    private final ForeignCallsProvider foreignCalls;
    private final ResolvedJavaType assertionErrorType;
    private final HashMap<ResolvedJavaMethod, SnippetRuntime.SubstrateForeignCallDescriptor> runtimeAssertionFatalReplacements;
    private static final AssertionError CACHED_ASSERTION_ERROR = new AssertionError();

    public ImplicitExceptionsPlugin(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls) {
        ResolvedJavaMethod[] assertionErrorCtors;
        this.metaAccess = metaAccess;
        this.foreignCalls = foreignCalls;
        this.assertionErrorType = metaAccess.lookupJavaType(AssertionError.class);
        this.runtimeAssertionFatalReplacements = new HashMap();
        block21: for (ResolvedJavaMethod ctor : assertionErrorCtors = this.assertionErrorType.getDeclaredConstructors()) {
            SnippetRuntime.SubstrateForeignCallDescriptor descriptor;
            switch (ctor.getSignature().toMethodDescriptor()) {
                case "()V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION;
                    break;
                }
                case "(Z)V": 
                case "(C)V": 
                case "(I)V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION_INT;
                    break;
                }
                case "(J)V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION_LONG;
                    break;
                }
                case "(F)V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION_FLOAT;
                    break;
                }
                case "(D)V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION_DOUBLE;
                    break;
                }
                case "(Ljava/lang/String;)V": 
                case "(Ljava/lang/Object;)V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION_OBJ;
                    break;
                }
                case "(Ljava/lang/String;Ljava/lang/Throwable;)V": {
                    descriptor = SnippetRuntime.FATAL_RUNTIME_ASSERTION_OBJ_OBJ;
                    break;
                }
                default: {
                    continue block21;
                }
            }
            this.runtimeAssertionFatalReplacements.put(ctor, descriptor);
        }
    }

    private static boolean methodMustNotAllocate(GraphBuilderContext b) {
        return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(b.getMethod());
    }

    public boolean handleNewInstance(GraphBuilderContext b, ResolvedJavaType type) {
        if (!b.parsingIntrinsic() && type.equals(this.assertionErrorType) && ImplicitExceptionsPlugin.methodMustNotAllocate(b)) {
            b.push(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(CACHED_ASSERTION_ERROR), (MetaAccessProvider)this.metaAccess, (StructuredGraph)b.getGraph()));
            return true;
        }
        return false;
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        String parsedMethodName = b.getMethod().getDeclaringClass().getName();
        if (!parsedMethodName.startsWith("Lcom/oracle/svm")) {
            return false;
        }
        SnippetRuntime.SubstrateForeignCallDescriptor descriptor = this.runtimeAssertionFatalReplacements.get(method);
        if (descriptor != null) {
            b.add((ValueNode)new ForeignCallNode(this.foreignCalls, (ForeignCallDescriptor)descriptor, args));
            b.add((ValueNode)new DeadEndNode());
            return true;
        }
        return false;
    }
}

