/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationSubstitutionField;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionMethod;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import com.oracle.svm.hosted.annotation.CustomSubstitutionType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnnotationSubstitutionType
extends CustomSubstitutionType<AnnotationSubstitutionField, AnnotationSubstitutionMethod> {
    private final String name;

    public AnnotationSubstitutionType(MetaAccessProvider metaAccess, ResolvedJavaType original) {
        super(original);
        assert (original.getSuperclass() == metaAccess.lookupJavaType(Proxy.class));
        assert (metaAccess.lookupJavaType(Annotation.class).isAssignableFrom(original));
        ResolvedJavaType annotationInterfaceType = AnnotationSupport.findAnnotationInterfaceType(original);
        assert (annotationInterfaceType.isAssignableFrom(original));
        assert (metaAccess.lookupJavaType(Annotation.class).isAssignableFrom(annotationInterfaceType));
        String n = annotationInterfaceType.getName();
        assert (n.endsWith(";"));
        this.name = n.substring(0, n.length() - 1) + "$$ProxyImpl;";
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "AnnotationType<" + this.toJavaName(true) + " -> " + this.original + ">";
    }
}

