/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.CallTreePrinter;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.hub.AnnotatedSuperInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.GenericInfo;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.SVMAnalysisPolicy;
import com.oracle.svm.hosted.analysis.SubstrateUnsupportedFeatures;
import com.oracle.svm.hosted.analysis.flow.SVMMethodTypeFlowBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.SuppressSVMWarnings;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.word.WordBase;

public class Inflation
extends BigBang {
    private Set<AnalysisField> handledUnknownValueFields;
    private Map<GenericInterfacesEncodingKey, Type[]> genericInterfacesMap;
    private Map<AnnotatedInterfacesEncodingKey, AnnotatedType[]> annotatedInterfacesMap;
    private Map<InterfacesEncodingKey, DynamicHub[]> interfacesEncodings;
    private final Pattern illegalCalleesPattern;
    private final Pattern targetCallersPattern;

    public Inflation(OptionValues options, AnalysisUniverse universe, HostedProviders providers, ForkJoinPool executor) {
        super(options, universe, providers, universe.hostVM(), executor, (UnsupportedFeatures)new SubstrateUnsupportedFeatures());
        String[] targetCallers = new String[]{"com\\.oracle\\.graal\\.", "org\\.graalvm[^\\.polyglot\\.nativeapi]"};
        this.targetCallersPattern = Inflation.buildPrefixMatchPattern(targetCallers);
        String[] illegalCallees = new String[]{"java\\.util\\.stream", "java\\.util\\.Collection\\.stream", "java\\.util\\.Arrays\\.stream"};
        this.illegalCalleesPattern = Inflation.buildPrefixMatchPattern(illegalCallees);
        this.handledUnknownValueFields = new HashSet<AnalysisField>();
        this.genericInterfacesMap = new HashMap<GenericInterfacesEncodingKey, Type[]>();
        this.annotatedInterfacesMap = new HashMap<AnnotatedInterfacesEncodingKey, AnnotatedType[]>();
        this.interfacesEncodings = new HashMap<InterfacesEncodingKey, DynamicHub[]>();
    }

    public SVMAnalysisPolicy svmAnalysisPolicy() {
        return (SVMAnalysisPolicy)super.analysisPolicy();
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(BigBang bb, MethodTypeFlow methodFlow) {
        return new SVMMethodTypeFlowBuilder(bb, methodFlow);
    }

    public boolean addRoot(JavaConstant constant, Object root) {
        SubstrateObjectConstant sConstant = (SubstrateObjectConstant)constant;
        return sConstant.setRoot(root);
    }

    public Object getRoot(JavaConstant constant) {
        SubstrateObjectConstant sConstant = (SubstrateObjectConstant)constant;
        return sConstant.getRoot();
    }

    protected void checkObjectGraph(ObjectScanner objectScanner) {
        this.universe.getFields().forEach(this::handleUnknownValueField);
        this.universe.getTypes().forEach(this::checkType);
        this.universe.getTypes().stream().filter(type -> type.isInstantiated() || type.isInTypeCheck() || type.isPrimitive()).forEach(type -> this.scanHub(objectScanner, (AnalysisType)type));
    }

    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    private void checkType(AnalysisType type) {
        DynamicHub hub = this.getHostVM().dynamicHub((ResolvedJavaType)type);
        if (hub.getGenericInfo() == null) {
            this.fillGenericInfo(type, hub);
        }
        if (hub.getAnnotatedSuperInfo() == null) {
            this.fillAnnotatedSuperInfo(type, hub);
        }
        if (type.getJavaKind() == JavaKind.Object) {
            if (type.isArray() && (type.isInstantiated() || type.isInTypeCheck())) {
                hub.getComponentHub().setArrayHub(hub);
            }
            try {
                AnalysisType enclosingType = type.getEnclosingType();
                if (enclosingType != null) {
                    hub.setEnclosingClass(this.getHostVM().dynamicHub((ResolvedJavaType)enclosingType));
                }
            }
            catch (UnsupportedFeatureException ex) {
                this.getUnsupportedFeatures().addMessage(type.toJavaName(true), null, ex.getMessage(), null, (Throwable)ex);
            }
            if (hub.getInterfacesEncoding() == null) {
                this.fillInterfaces(type, hub);
            }
            try {
                Annotation[] annotations = type.getWrappedWithoutResolve().getAnnotations();
                hub.setAnnotationsEncoding(Inflation.encodeAnnotations(this.metaAccess, annotations, hub.getAnnotationsEncoding()));
            }
            catch (ArrayStoreException e) {
                hub.setAnnotationsEncoding(e);
            }
            if (type.getSuperclass() != null && type.getSuperclass().equals((Object)this.metaAccess.lookupJavaType(Enum.class)) && hub.getEnumConstantsShared() == null) {
                Enum[] enumConstants;
                AnalysisField found = null;
                for (AnalysisField f : type.getStaticFields()) {
                    if (!f.getName().endsWith("$VALUES")) continue;
                    if (found != null) {
                        found = null;
                        break;
                    }
                    found = f;
                }
                if (found == null) {
                    enumConstants = (Enum[])type.getJavaClass().getEnumConstants();
                } else {
                    enumConstants = (Enum[])SubstrateObjectConstant.asObject((Constant)this.getConstantReflectionProvider().readFieldValue(found, null));
                    assert (enumConstants != null);
                }
                hub.setEnumConstants(enumConstants);
            }
        }
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.handledUnknownValueFields = null;
        this.genericInterfacesMap = null;
        this.annotatedInterfacesMap = null;
        this.interfacesEncodings = null;
    }

    public boolean isValidClassLoader(Object valueObj) {
        return valueObj.getClass().getClassLoader() == null || !(valueObj.getClass().getClassLoader() instanceof NativeImageClassLoader) || valueObj.getClass().getClassLoader() == Thread.currentThread().getContextClassLoader();
    }

    public void checkUserLimitations() {
        int maxReachableTypes = NativeImageOptions.MaxReachableTypes.getValue();
        if (maxReachableTypes >= 0) {
            CallTreePrinter callTreePrinter = new CallTreePrinter((BigBang)this);
            callTreePrinter.buildCallTree();
            int numberOfTypes = callTreePrinter.classesSet(false).size();
            if (numberOfTypes > maxReachableTypes) {
                throw UserError.abort("Reachable " + numberOfTypes + " types but only " + maxReachableTypes + " allowed (because the " + NativeImageOptions.MaxReachableTypes.getName() + " option is set). To see all reachable types use " + AnalysisReportsOptions.PrintAnalysisCallTree.getName() + "; to change the maximum number of allowed types use " + NativeImageOptions.MaxReachableTypes.getName() + ".");
            }
        }
    }

    private void fillGenericInfo(AnalysisType type, DynamicHub hub) {
        Type genericSuperClass;
        Type[] allGenericInterfaces;
        Class javaClass = type.getJavaClass();
        TypeVariable<Class<T>>[] typeParameters = javaClass.getTypeParameters();
        try {
            allGenericInterfaces = javaClass.getGenericInterfaces();
        }
        catch (NoClassDefFoundError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            allGenericInterfaces = new Type[]{};
        }
        Type[] genericInterfaces = (Type[])Arrays.stream(allGenericInterfaces).filter(this::isTypeAllowed).toArray(Type[]::new);
        Type[] cachedGenericInterfaces = this.genericInterfacesMap.computeIfAbsent(new GenericInterfacesEncodingKey(genericInterfaces), k -> genericInterfaces);
        try {
            genericSuperClass = javaClass.getGenericSuperclass();
        }
        catch (NoClassDefFoundError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            genericSuperClass = null;
        }
        if (!this.isTypeAllowed(genericSuperClass)) {
            genericSuperClass = null;
        }
        hub.setGenericInfo(GenericInfo.factory(typeParameters, cachedGenericInterfaces, genericSuperClass));
    }

    private void fillAnnotatedSuperInfo(AnalysisType type, DynamicHub hub) {
        AnnotatedType[] allAnnotatedInterfaces;
        AnnotatedType annotatedSuperclass;
        Class javaClass = type.getJavaClass();
        try {
            annotatedSuperclass = javaClass.getAnnotatedSuperclass();
        }
        catch (NoClassDefFoundError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            annotatedSuperclass = null;
        }
        if (annotatedSuperclass != null && !this.isTypeAllowed(annotatedSuperclass.getType())) {
            annotatedSuperclass = null;
        }
        try {
            allAnnotatedInterfaces = javaClass.getAnnotatedInterfaces();
        }
        catch (NoClassDefFoundError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            allAnnotatedInterfaces = new AnnotatedType[]{};
        }
        AnnotatedType[] annotatedInterfaces = (AnnotatedType[])Arrays.stream(allAnnotatedInterfaces).filter(ai -> this.isTypeAllowed(ai.getType())).toArray(AnnotatedType[]::new);
        AnnotatedType[] cachedAnnotatedInterfaces = this.annotatedInterfacesMap.computeIfAbsent(new AnnotatedInterfacesEncodingKey(annotatedInterfaces), k -> annotatedInterfaces);
        hub.setAnnotatedSuperInfo(AnnotatedSuperInfo.factory(annotatedSuperclass, cachedAnnotatedInterfaces));
    }

    private boolean isTypeAllowed(Type t) {
        if (t instanceof Class) {
            Optional resolved = this.metaAccess.optionalLookupJavaType((Class)t);
            return resolved.isPresent() && this.universe.platformSupported((AnnotatedElement)resolved.get());
        }
        return true;
    }

    private void fillInterfaces(AnalysisType type, DynamicHub hub) {
        SVMHost svmHost = (SVMHost)this.hostVM;
        AnalysisType[] aInterfaces = type.getInterfaces();
        if (aInterfaces.length == 0) {
            hub.setInterfacesEncoding(null);
        } else if (aInterfaces.length == 1) {
            hub.setInterfacesEncoding(svmHost.dynamicHub((ResolvedJavaType)aInterfaces[0]));
        } else {
            hub.setInterfacesEncoding(this.interfacesEncodings.computeIfAbsent(new InterfacesEncodingKey(aInterfaces), k -> k.createHubs()));
        }
    }

    private void scanHub(ObjectScanner objectScanner, AnalysisType type) {
        SVMHost svmHost = (SVMHost)this.hostVM;
        JavaConstant hubConstant = SubstrateObjectConstant.forObject(svmHost.dynamicHub((ResolvedJavaType)type));
        objectScanner.scanConstant(hubConstant, (Object)"Hub");
    }

    private void handleUnknownValueField(AnalysisField field) {
        if (this.handledUnknownValueFields.contains(field)) {
            return;
        }
        UnknownObjectField unknownObjectField = (UnknownObjectField)field.getAnnotation(UnknownObjectField.class);
        UnknownPrimitiveField unknownPrimitiveField = (UnknownPrimitiveField)field.getAnnotation(UnknownPrimitiveField.class);
        if (unknownObjectField != null) {
            assert (!Modifier.isFinal(field.getModifiers())) : "@UnknownObjectField annotated field " + field.format("%H.%n") + " cannot be final";
            assert (field.getJavaKind() == JavaKind.Object);
            field.setCanBeNull(unknownObjectField.canBeNull());
            List<AnalysisType> aAnnotationTypes = this.extractAnnotationTypes(field, unknownObjectField);
            if (field.isAccessed()) {
                for (AnalysisType type : aAnnotationTypes) {
                    type.registerAsAllocated(null);
                }
            }
            this.handleUnknownObjectField(field, aAnnotationTypes.toArray(new AnalysisType[aAnnotationTypes.size()]));
        } else if (unknownPrimitiveField != null) {
            assert (!Modifier.isFinal(field.getModifiers())) : "@UnknownPrimitiveField annotated field " + field.format("%H.%n") + " cannot be final";
            field.registerAsWritten(null);
        }
        this.handledUnknownValueFields.add(field);
    }

    private List<AnalysisType> extractAnnotationTypes(AnalysisField field, UnknownObjectField unknownObjectField) {
        ArrayList annotationTypes = new ArrayList(Arrays.asList(unknownObjectField.types()));
        for (String string : unknownObjectField.fullyQualifiedTypes()) {
            try {
                Class<?> annotationType = Class.forName(string);
                annotationTypes.add(annotationType);
            }
            catch (ClassNotFoundException e) {
                throw JVMCIError.shouldNotReachHere((String)("Annotation type not found " + string));
            }
        }
        ArrayList<AnalysisType> aAnnotationTypes = new ArrayList<AnalysisType>();
        AnalysisType declaredType = field.getType();
        for (Class clazz : annotationTypes) {
            AnalysisType aAnnotationType = this.metaAccess.lookupJavaType(clazz);
            assert (!WordBase.class.isAssignableFrom(clazz)) : "Annotation type must not be a subtype of WordBase: field: " + field + " | declared type: " + declaredType + " | annotation type: " + clazz;
            assert (declaredType.isAssignableFrom((ResolvedJavaType)aAnnotationType)) : "Annotation type must be a subtype of the declared type: field: " + field + " | declared type: " + declaredType + " | annotation type: " + clazz;
            assert (aAnnotationType.isArray() || aAnnotationType.isInstanceClass() && !Modifier.isAbstract(aAnnotationType.getModifiers())) : "Annotation type failure: field: " + field + " | annotation type " + aAnnotationType;
            aAnnotationTypes.add(aAnnotationType);
        }
        return aAnnotationTypes;
    }

    private void handleUnknownObjectField(AnalysisField aField, AnalysisType ... declaredTypes) {
        assert (aField.getJavaKind() == JavaKind.Object);
        aField.registerAsWritten(null);
        for (AnalysisType fieldDeclaredType : declaredTypes) {
            AllInstantiatedTypeFlow fieldDeclaredTypeFlow = fieldDeclaredType.getTypeFlow((BigBang)this, true);
            if (aField.isStatic()) {
                fieldDeclaredTypeFlow.addUse((BigBang)this, (TypeFlow)aField.getStaticFieldFlow());
                continue;
            }
            fieldDeclaredTypeFlow.addUse((BigBang)this, (TypeFlow)aField.getInitialInstanceFieldFlow());
            if (!fieldDeclaredType.isArray()) continue;
            AnalysisType fieldComponentType = fieldDeclaredType.getComponentType();
            aField.getInitialInstanceFieldFlow().addUse((BigBang)this, (TypeFlow)aField.getInstanceFieldFlow());
            if (fieldComponentType.isPrimitive()) continue;
            ArrayElementsTypeFlow elementsFlow = fieldDeclaredType.getContextInsensitiveAnalysisObject().getArrayElementsFlow((BigBang)this, true);
            fieldComponentType.getTypeFlow((BigBang)this, false).addUse((BigBang)this, (TypeFlow)elementsFlow);
        }
    }

    public static Object encodeAnnotations(AnalysisMetaAccess metaAccess, Annotation[] allAnnotations, Object oldEncoding) {
        Annotation[] newEncoding;
        if (allAnnotations.length == 0) {
            newEncoding = null;
        } else {
            ArrayList<Annotation> usedAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : allAnnotations) {
                try {
                    AnalysisType annotationClass = metaAccess.lookupJavaType(annotation.getClass());
                    if (!Inflation.isAnnotationUsed(annotationClass)) continue;
                    usedAnnotations.add(annotation);
                }
                catch (AnalysisError.TypeNotFoundError typeNotFoundError) {
                    // empty catch block
                }
            }
            newEncoding = usedAnnotations.size() == 0 ? null : (usedAnnotations.size() == 1 ? (Annotation[])usedAnnotations.get(0) : usedAnnotations.toArray(new Annotation[usedAnnotations.size()]));
        }
        if (oldEncoding == newEncoding || oldEncoding instanceof Annotation[] && newEncoding instanceof Annotation[] && Arrays.equals((Annotation[])oldEncoding, newEncoding)) {
            return oldEncoding;
        }
        return newEncoding;
    }

    private static boolean isAnnotationUsed(AnalysisType annotationType) {
        if (annotationType.isInstantiated() || annotationType.isInTypeCheck()) {
            return true;
        }
        assert (annotationType.getInterfaces().length == 1) : annotationType;
        AnalysisType annotationInterfaceType = annotationType.getInterfaces()[0];
        return annotationInterfaceType.isInstantiated() || annotationInterfaceType.isInTypeCheck();
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        if (SVMHost.isUnknownClass((ResolvedJavaType)type)) {
            return false;
        }
        if (type.isArray() && SVMHost.isUnknownClass((ResolvedJavaType)type.getComponentType())) {
            throw JVMCIError.unimplemented();
        }
        return true;
    }

    private static Pattern buildPrefixMatchPattern(String[] targetPrefixes) {
        String patternStr = "";
        for (int i = 0; i < targetPrefixes.length; ++i) {
            String prefix = targetPrefixes[i];
            patternStr = patternStr + prefix;
            patternStr = patternStr + "(.*)";
            if (i >= targetPrefixes.length - 1) continue;
            patternStr = patternStr + "|";
        }
        return Pattern.compile(patternStr);
    }

    public boolean isCallAllowed(BigBang bb, AnalysisMethod caller, AnalysisMethod callee, NodeSourcePosition srcPosition) {
        String callerName;
        String calleeName = callee.format("%H.%n");
        if (this.illegalCalleesPattern.matcher(calleeName).find() && this.targetCallersPattern.matcher(callerName = caller.format("%H.%n")).find()) {
            SuppressSVMWarnings suppress = (SuppressSVMWarnings)caller.getAnnotation(SuppressSVMWarnings.class);
            for (AnalysisType callerType = caller.getDeclaringClass(); suppress == null && callerType != null; callerType = callerType.getEnclosingType()) {
                suppress = (SuppressSVMWarnings)callerType.getAnnotation(SuppressSVMWarnings.class);
            }
            if (suppress != null) {
                String[] reasons;
                for (String r : reasons = suppress.value()) {
                    if (!r.equals("AllowUseOfStreamAPI")) continue;
                    return true;
                }
            }
            String message = "Illegal: Graal/Truffle use of Stream API: " + calleeName;
            int bci = srcPosition.getBCI();
            String trace = caller.asStackTraceElement(bci).toString();
            bb.getUnsupportedFeatures().addMessage(callerName, caller, message, trace);
            return false;
        }
        return true;
    }

    public SubstrateReplacements getReplacements() {
        return (SubstrateReplacements)super.getReplacements();
    }

    class InterfacesEncodingKey {
        final AnalysisType[] aInterfaces;

        InterfacesEncodingKey(AnalysisType[] aInterfaces) {
            this.aInterfaces = aInterfaces;
        }

        DynamicHub[] createHubs() {
            SVMHost svmHost = (SVMHost)Inflation.this.hostVM;
            DynamicHub[] hubs = new DynamicHub[this.aInterfaces.length];
            for (int i = 0; i < hubs.length; ++i) {
                hubs[i] = svmHost.dynamicHub((ResolvedJavaType)this.aInterfaces[i]);
            }
            return hubs;
        }

        public boolean equals(Object obj) {
            return obj instanceof InterfacesEncodingKey && Arrays.equals(this.aInterfaces, ((InterfacesEncodingKey)obj).aInterfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.aInterfaces);
        }
    }

    class AnnotatedInterfacesEncodingKey {
        final AnnotatedType[] interfaces;

        AnnotatedInterfacesEncodingKey(AnnotatedType[] aInterfaces) {
            this.interfaces = aInterfaces;
        }

        public boolean equals(Object obj) {
            return obj instanceof AnnotatedInterfacesEncodingKey && Arrays.equals(this.interfaces, ((AnnotatedInterfacesEncodingKey)obj).interfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.interfaces);
        }
    }

    class GenericInterfacesEncodingKey {
        final Type[] interfaces;

        GenericInterfacesEncodingKey(Type[] aInterfaces) {
            this.interfaces = aInterfaces;
        }

        public boolean equals(Object obj) {
            return obj instanceof GenericInterfacesEncodingKey && Arrays.equals(this.interfaces, ((GenericInterfacesEncodingKey)obj).interfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.interfaces);
        }
    }
}

