/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jni.JNIRuntimeAccess;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.RuntimeClassInitialization;
import org.graalvm.nativeimage.RuntimeReflection;
import sun.security.ec.ECKeyPairGenerator;
import sun.security.jca.Providers;
import sun.security.provider.NativePRNG;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

@AutomaticFeature
public class SecurityServicesFeature
implements Feature {
    private static final String SUN_PROVIDER = "SUN";
    private static final String SECURE_RANDOM_SERVICE = "SecureRandom";
    private static final String MESSAGE_DIGEST_SERVICE = "MessageDigest";
    private static final String SIGNATURE_SERVICE = "Signature";
    private static final String CIPHER_SERVICE = "Cipher";
    private static final String KEY_AGREEMENT_SERVICE = "KeyAgreement";
    private static final String[] emptyStringArray = new String[0];
    private static final String SEP = " , ";

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{NativePRNG.class});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{NativePRNG.Blocking.class});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{NativePRNG.NonBlocking.class});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.security.provider.SeedGenerator")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.security.provider.SecureRandom$SeederHolder")});
        if (!GraalServices.Java8OrEarlier) {
            RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.security.provider.FileInputStreamPool")});
        }
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.UUID$Holder")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.security.jca.JCAUtil$CachedSecureRandomHolder")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("com.sun.crypto.provider.SunJCE$SecureRandomHolder")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.security.krb5.Confounder")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{SSLContext.class});
        if (SubstrateOptions.EnableAllSecurityServices.getValue().booleanValue()) {
            SecurityServicesFeature.prepareSunEC();
        }
    }

    private static void prepareSunEC() {
        JNIRuntimeAccess.register(byte[].class);
        try {
            JNIRuntimeAccess.register(ECKeyPairGenerator.class.getDeclaredMethod("generateECKeyPair", Integer.TYPE, byte[].class, byte[].class));
        }
        catch (NoSuchMethodException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        boolean enableAllSecurityServices = SubstrateOptions.EnableAllSecurityServices.getValue();
        SecurityServicesFeature.trace("Registering security services...");
        for (Provider provider : Providers.getProviderList().providers()) {
            if (!enableAllSecurityServices && !SecurityServicesFeature.isSunProvider(provider)) continue;
            SecurityServicesFeature.register(provider);
            for (Provider.Service service : provider.getServices()) {
                if (!enableAllSecurityServices && !SecurityServicesFeature.isMessageDigest(service) && !SecurityServicesFeature.isSecureRandom(service)) continue;
                SecurityServicesFeature.register(access, service);
            }
        }
        if (enableAllSecurityServices) {
            try {
                SecurityServicesFeature.trace("Registering engine constructor parameter classes...");
                Field knownEnginesField = Provider.class.getDeclaredField("knownEngines");
                knownEnginesField.setAccessible(true);
                Class engineDescriptionClass = access.findClassByName("java.security.Provider$EngineDescription");
                Field constructorParameterClassNameField = engineDescriptionClass.getDeclaredField("constructorParameterClassName");
                constructorParameterClassNameField.setAccessible(true);
                Map knownEngines = (Map)knownEnginesField.get(null);
                for (Object engineDescription : knownEngines.values()) {
                    String constructorParameterClassName = (String)constructorParameterClassNameField.get(engineDescription);
                    if (constructorParameterClassName == null) continue;
                    Class constructorParameterClass = access.findClassByName(constructorParameterClassName);
                    SecurityServicesFeature.registerForReflection(constructorParameterClass);
                    SecurityServicesFeature.trace("Class registered for reflection: " + constructorParameterClass);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                VMError.shouldNotReachHere(e);
            }
            Class javaKeyStoreJks = access.findClassByName("sun.security.provider.JavaKeyStore$JKS");
            SecurityServicesFeature.registerForReflection(javaKeyStoreJks);
            SecurityServicesFeature.trace("Class registered for reflection: " + javaKeyStoreJks);
            try {
                SecurityServicesFeature.trace("Registering X.509 certificate extensions...");
                Field extensionMapField = OIDMap.class.getDeclaredField("nameMap");
                extensionMapField.setAccessible(true);
                Map map = (Map)extensionMapField.get(null);
                for (String name : map.keySet()) {
                    Class<?> extensionClass = OIDMap.getClass(name);
                    assert (Extension.class.isAssignableFrom(extensionClass));
                    SecurityServicesFeature.registerForReflection(extensionClass);
                    SecurityServicesFeature.trace("Class registered for reflection: " + extensionClass);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | CertificateException e) {
                VMError.shouldNotReachHere(e);
            }
        }
    }

    private static void register(Provider provider) {
        SecurityServicesFeature.registerForReflection(provider.getClass());
        try {
            Method getVerificationResult = Class.forName("javax.crypto.JceSecurity").getDeclaredMethod("getVerificationResult", Provider.class);
            getVerificationResult.setAccessible(true);
            getVerificationResult.invoke(null, provider);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    private static void register(Feature.BeforeAnalysisAccess access, Provider.Service service) {
        Class serviceClass = access.findClassByName(service.getClassName());
        if (serviceClass != null) {
            SecurityServicesFeature.registerForReflection(serviceClass);
            if (SecurityServicesFeature.isSignature(service) || SecurityServicesFeature.isCipher(service) || SecurityServicesFeature.isKeyAgreement(service)) {
                for (String keyClassName : SecurityServicesFeature.getSupportedKeyClasses(service)) {
                    Class keyClass = access.findClassByName(keyClassName);
                    if (keyClass == null) continue;
                    SecurityServicesFeature.registerForReflection(keyClass);
                }
            }
            SecurityServicesFeature.trace("Service registered: " + SecurityServicesFeature.asString(service));
        } else {
            SecurityServicesFeature.trace("Service registration failed: " + SecurityServicesFeature.asString(service) + ". Cause: class not found " + service.getClassName());
        }
    }

    private static void registerForReflection(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.register((Executable[])clazz.getConstructors());
    }

    private static boolean isSunProvider(Provider provider) {
        return provider.getName().equals(SUN_PROVIDER);
    }

    private static boolean isSecureRandom(Provider.Service s) {
        return s.getType().equals(SECURE_RANDOM_SERVICE);
    }

    private static boolean isMessageDigest(Provider.Service s) {
        return s.getType().equals(MESSAGE_DIGEST_SERVICE);
    }

    private static boolean isSignature(Provider.Service s) {
        return s.getType().equals(SIGNATURE_SERVICE);
    }

    private static boolean isCipher(Provider.Service s) {
        return s.getType().equals(CIPHER_SERVICE);
    }

    private static boolean isKeyAgreement(Provider.Service s) {
        return s.getType().equals(KEY_AGREEMENT_SERVICE);
    }

    private static String[] getSupportedKeyClasses(Provider.Service s) {
        assert (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s));
        String supportedKeyClasses = s.getAttribute("SupportedKeyClasses");
        if (supportedKeyClasses != null) {
            return supportedKeyClasses.split("\\|");
        }
        return emptyStringArray;
    }

    private static String asString(Provider.Service s) {
        String str = "Provider = " + s.getProvider().getName() + SEP;
        str = str + "Type = " + s.getType() + SEP;
        str = str + "Algorithm = " + s.getAlgorithm() + SEP;
        str = str + "Class = " + s.getClassName();
        if (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s)) {
            str = str + " , SupportedKeyClasses = " + Arrays.toString(SecurityServicesFeature.getSupportedKeyClasses(s));
        }
        return str;
    }

    private static void trace(String trace) {
        if (Options.TraceSecurityServices.getValue().booleanValue()) {
            System.out.println(trace);
        }
    }

    static class Options {
        @Option(help={"Enable trace logging for the security services feature."})
        static final HostedOptionKey<Boolean> TraceSecurityServices = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }
}

