/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageBuildTask;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Stream;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;

public class NativeImageGeneratorRunner
implements ImageBuildTask {
    public static final String IMAGE_CLASSPATH_PREFIX = "-imagecp";
    public static final String WATCHPID_PREFIX = "-watchpid";
    private volatile NativeImageGenerator generator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        String[] classpath = NativeImageGeneratorRunner.extractImageClassPath(arguments);
        final int watchPID = NativeImageGeneratorRunner.extractWatchPID(arguments);
        TimerTask timerTask = null;
        if (watchPID >= 0) {
            VMError.guarantee(OS.getCurrent().hasProcFS, "-watchpid <pid> requires system with /proc");
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    try (Stream<String> stream = Files.lines(Paths.get("/proc/" + watchPID + "/comm", new String[0]));){
                        if (stream.noneMatch(line -> line.contains("native-image"))) {
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        System.exit(1);
                    }
                }
            };
            java.util.Timer timer = new java.util.Timer("native-image pid watcher");
            timer.scheduleAtFixedRate(timerTask, 0L, 1000L);
        }
        int exitStatus = 1;
        try {
            NativeImageClassLoader nativeImageClassLoader = NativeImageGeneratorRunner.installNativeImageClassLoader(classpath);
            exitStatus = new NativeImageGeneratorRunner().build(arguments.toArray(new String[arguments.size()]), classpath, nativeImageClassLoader);
        }
        finally {
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
        System.exit(exitStatus == 0 ? 0 : 1);
    }

    public static NativeImageClassLoader installNativeImageClassLoader(String[] classpath) {
        ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
        NativeImageClassLoader nativeImageClassLoader = new NativeImageClassLoader(NativeImageGeneratorRunner.verifyClassPathAndConvertToURLs(classpath), applicationClassLoader);
        Thread.currentThread().setContextClassLoader(nativeImageClassLoader);
        return nativeImageClassLoader;
    }

    public static String[] extractImageClassPath(List<String> arguments) {
        int cpArgIndex = arguments.indexOf(IMAGE_CLASSPATH_PREFIX);
        String msgTail = " '-imagecp <image classpath>' argument.";
        if (cpArgIndex == -1) {
            throw UserError.abort("Missing" + msgTail);
        }
        arguments.remove(cpArgIndex);
        try {
            String imageClasspath = arguments.remove(cpArgIndex);
            return imageClasspath.split(File.pathSeparator, Integer.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            throw UserError.abort("Missing <image classpath> for" + msgTail);
        }
    }

    public static int extractWatchPID(List<String> arguments) {
        int cpIndex = arguments.indexOf(WATCHPID_PREFIX);
        if (cpIndex >= 0) {
            if (cpIndex + 1 >= arguments.size()) {
                throw UserError.abort("ProcessID must be provided after the '-watchpid' argument.\n");
            }
            arguments.remove(cpIndex);
            String pidStr = arguments.get(cpIndex);
            arguments.remove(cpIndex);
            return Integer.parseInt(pidStr);
        }
        return -1;
    }

    private static URL[] verifyClassPathAndConvertToURLs(String[] classpath) {
        return (URL[])new HashSet<String>(Arrays.asList(classpath)).stream().flatMap(ImageClassLoader::toClassPathEntries).map(v -> {
            try {
                return v.toAbsolutePath().toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw UserError.abort("Invalid classpath element '" + v + "'. Make sure that all paths provided with '" + IMAGE_CLASSPATH_PREFIX + "' are correct.");
            }
        }).toArray(URL[]::new);
    }

    public static boolean isValidJavaVersion() {
        return Boolean.getBoolean("substratevm.IgnoreGraalVersionCheck") || GraalServices.Java8OrEarlier;
    }

    private static void reportToolUserError(String msg) {
        NativeImageGeneratorRunner.reportUserError("native-image " + msg);
    }

    private static boolean isValidArchitecture() {
        return GraalAccess.getOriginalTarget().arch instanceof AMD64;
    }

    private static boolean isValidOperatingSystem() {
        return OS.getCurrent() == OS.LINUX || OS.getCurrent() == OS.DARWIN || OS.getCurrent() == OS.WINDOWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildImage(String[] arguments, String[] classpath, ClassLoader classLoader) {
        if (!NativeImageGeneratorRunner.verifyValidJavaVersionAndPlatform()) {
            return -1;
        }
        Timer totalTimer = new Timer("[total]", false);
        ForkJoinPool analysisExecutor = null;
        ForkJoinPool compilationExecutor = null;
        OptionValues parsedHostedOptions = null;
        try (Timer.StopTimer ignored = totalTimer.start();){
            ImageClassLoader imageClassLoader;
            Timer classlistTimer = new Timer("classlist", false);
            try (Timer.StopTimer ignored1 = classlistTimer.start();){
                imageClassLoader = ImageClassLoader.create(NativeImageGenerator.defaultPlatform(classLoader), classpath, classLoader);
            }
            HostedOptionParser optionParser = new HostedOptionParser(imageClassLoader);
            Object[] remainingArgs = optionParser.parse(arguments);
            if (remainingArgs.length > 0) {
                throw UserError.abort("Unknown options: " + Arrays.toString(remainingArgs));
            }
            parsedHostedOptions = new OptionValues(optionParser.getHostedValues());
            DebugContext debug = DebugContext.create((OptionValues)parsedHostedOptions, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection()));
            String imageName = (String)NativeImageOptions.Name.getValue(parsedHostedOptions);
            if (imageName.length() == 0) {
                throw UserError.abort("No output file name specified. Use '" + SubstrateOptionsParser.commandArgument(NativeImageOptions.Name, "<output-file>") + "'.");
            }
            totalTimer.setPrefix(imageName);
            classlistTimer.setPrefix(imageName);
            classlistTimer.print();
            HashMap<Method, CEntryPointData> entryPoints = new HashMap<Method, CEntryPointData>();
            Method mainEntryPoint = null;
            JavaMainWrapper.JavaMainSupport javaMainSupport = null;
            AbstractBootImage.NativeImageKind k = AbstractBootImage.NativeImageKind.valueOf((String)NativeImageOptions.Kind.getValue(parsedHostedOptions));
            if (k.executable) {
                Class<?> mainClass;
                String className = (String)NativeImageOptions.Class.getValue(parsedHostedOptions);
                if (className == null || className.length() == 0) {
                    throw UserError.abort("Must specify main entry point class when building " + (Object)((Object)k) + " native image. Use '" + SubstrateOptionsParser.commandArgument(NativeImageOptions.Class, "<fully-qualified-class-name>") + "'.");
                }
                try {
                    mainClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw UserError.abort("Main entry point class '" + className + "' not found.");
                }
                String mainEntryPointName = (String)NativeImageOptions.Method.getValue(parsedHostedOptions);
                if (mainEntryPointName == null || mainEntryPointName.length() == 0) {
                    throw UserError.abort("Must specify main entry point method when building " + (Object)((Object)k) + " native image. Use '" + SubstrateOptionsParser.commandArgument(NativeImageOptions.Method, "<method-name>") + "'.");
                }
                try {
                    mainEntryPoint = mainClass.getDeclaredMethod(mainEntryPointName, Integer.TYPE, CCharPointerPointer.class);
                }
                catch (NoSuchMethodException ignored2) {
                    try {
                        Method javaMainMethod = mainClass.getDeclaredMethod(mainEntryPointName, String[].class);
                        javaMainMethod.setAccessible(true);
                        if (javaMainMethod.getReturnType() != Void.TYPE) {
                            throw UserError.abort("Java main method must have return type void. Change the return type of method '" + mainClass.getName() + "." + mainEntryPointName + "(String[])'.");
                        }
                        int mainMethodModifiers = javaMainMethod.getModifiers();
                        if (!Modifier.isPublic(mainMethodModifiers)) {
                            throw UserError.abort("Method '" + mainClass.getName() + "." + mainEntryPointName + "(String[])' is not accessible.  Please make it 'public'.");
                        }
                        javaMainSupport = new JavaMainWrapper.JavaMainSupport(javaMainMethod);
                        mainEntryPoint = JavaMainWrapper.class.getDeclaredMethod("run", Integer.TYPE, CCharPointerPointer.class);
                    }
                    catch (NoSuchMethodException ex) {
                        throw UserError.abort("Method '" + mainClass.getName() + "." + mainEntryPointName + "' is declared as the main entry point but it can not be found. Make sure that class '" + mainClass.getName() + "' is on the classpath and that method '" + mainEntryPointName + "(String[])' exists in that class.");
                    }
                }
                CEntryPoint annotation = mainEntryPoint.getAnnotation(CEntryPoint.class);
                if (annotation == null) {
                    throw UserError.abort("Entry point must have the '@" + CEntryPoint.class.getSimpleName() + "' annotation");
                }
                entryPoints.put(mainEntryPoint, CEntryPointData.create(mainEntryPoint));
                Class<?>[] pt = mainEntryPoint.getParameterTypes();
                if (pt.length != 2 || pt[0] != Integer.TYPE || pt[1] != CCharPointerPointer.class || mainEntryPoint.getReturnType() != Integer.TYPE) {
                    throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.");
                }
            }
            int maxConcurrentThreads = NativeImageOptions.getMaximumNumberOfConcurrentThreads(parsedHostedOptions);
            analysisExecutor = Inflation.createExecutor((DebugContext)debug, (int)NativeImageOptions.getMaximumNumberOfAnalysisThreads(parsedHostedOptions));
            compilationExecutor = Inflation.createExecutor((DebugContext)debug, (int)maxConcurrentThreads);
            this.generator = new NativeImageGenerator(imageClassLoader, optionParser);
            this.generator.run(entryPoints, mainEntryPoint, javaMainSupport, imageName, k, SubstitutionProcessor.IDENTITY, analysisExecutor, compilationExecutor, optionParser.getRuntimeOptionNames());
        }
        catch (InterruptImageBuilding e) {
            if (analysisExecutor != null) {
                analysisExecutor.shutdownNow();
            }
            if (compilationExecutor != null) {
                compilationExecutor.shutdownNow();
            }
            e.getReason().ifPresent(NativeImageGeneratorRunner::info);
            int n = 0;
            return n;
        }
        catch (UserError.UserException e) {
            NativeImageGeneratorRunner.reportUserError(e, parsedHostedOptions);
            int n = -1;
            return n;
        }
        catch (AnalysisError e) {
            NativeImageGeneratorRunner.reportUserError(e, parsedHostedOptions);
            int n = -1;
            return n;
        }
        catch (ParallelExecutionException pee) {
            boolean hasUserError = false;
            for (Throwable exception : pee.getExceptions()) {
                if (exception instanceof UserError.UserException) {
                    NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                    hasUserError = true;
                    continue;
                }
                if (!(exception instanceof AnalysisError)) continue;
                NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                hasUserError = true;
            }
            if (hasUserError) {
                int n = -1;
                return n;
            }
            if (pee.getExceptions().size() > 1) {
                System.err.println(pee.getExceptions().size() + " fatal errors detected:");
            }
            for (Throwable exception : pee.getExceptions()) {
                NativeImageGeneratorRunner.reportFatalError(exception);
            }
            int n = -1;
            return n;
        }
        catch (Throwable e) {
            NativeImageGeneratorRunner.reportFatalError(e);
            int n = -1;
            return n;
        }
        finally {
            ImageSingletonsSupportImpl.HostedManagement.clearInThread();
        }
        totalTimer.print();
        return 0;
    }

    public static boolean verifyValidJavaVersionAndPlatform() {
        if (!NativeImageGeneratorRunner.isValidJavaVersion()) {
            NativeImageGeneratorRunner.reportToolUserError("supports only Java 1.8 with an update version 40+. Detected Java version is: " + NativeImageGeneratorRunner.getJavaVersion());
            return false;
        }
        if (!NativeImageGeneratorRunner.isValidArchitecture()) {
            NativeImageGeneratorRunner.reportToolUserError("runs only on architecture AMD64. Detected architecture: " + GraalAccess.getOriginalTarget().arch.getClass().getSimpleName());
        }
        if (!NativeImageGeneratorRunner.isValidOperatingSystem()) {
            NativeImageGeneratorRunner.reportToolUserError("runs on Linux, Mac OS X and Windows only. Detected OS: " + System.getProperty("os.name"));
            return false;
        }
        return true;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static void reportFatalError(Throwable e) {
        System.err.print("Fatal error: ");
        e.printStackTrace();
    }

    public static void reportUserError(String msg) {
        System.err.println("Error: " + msg);
    }

    public static void reportUserError(Throwable e, OptionValues parsedHostedOptions) {
        if (e instanceof UserError.UserException) {
            UserError.UserException ue = (UserError.UserException)e;
            for (String message : ue.getMessages()) {
                NativeImageGeneratorRunner.reportUserError(message);
            }
        } else {
            NativeImageGeneratorRunner.reportUserError(e.getMessage());
        }
        if (parsedHostedOptions != null && ((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            e.printStackTrace();
        } else {
            NativeImageGeneratorRunner.reportUserError("Use " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportExceptionStackTraces, "+") + " to print stacktrace of underlying exception");
        }
    }

    private static void info(String msg) {
        System.out.println("Info: " + msg);
    }

    @Override
    public int build(String[] args, String[] classpath, ClassLoader imageClassLoader) {
        return this.buildImage(args, classpath, imageClassLoader);
    }

    @Override
    public void interruptBuild() {
        NativeImageGenerator generatorInstance = this.generator;
        if (generatorInstance != null) {
            generatorInstance.interruptBuild();
        }
    }
}

