/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public class ExceptionSynthesizer {
    private static final Method throwClassNotFoundExceptionMethod;
    private static final Method throwNoSuchFieldExceptionMethod;
    private static final Method throwNoSuchMethodExceptionMethod;
    private static final Method throwNoClassDefFoundErrorMethod;
    private static final Method throwNoSuchFieldErrorMethod;
    private static final Method throwNoSuchMethodErrorMethod;

    public static void throwClassNotFoundException(GraphBuilderContext b, String targetClass) {
        ExceptionSynthesizer.throwException(b, targetClass, throwClassNotFoundExceptionMethod);
    }

    public static void throwNoSuchFieldException(GraphBuilderContext b, String targetField) {
        ExceptionSynthesizer.throwException(b, targetField, throwNoSuchFieldExceptionMethod);
    }

    public static void throwNoSuchMethodException(GraphBuilderContext b, String targetMethod) {
        ExceptionSynthesizer.throwException(b, targetMethod, throwNoSuchMethodExceptionMethod);
    }

    public static void throwNoClassDefFoundError(GraphBuilderContext b, String targetField) {
        ExceptionSynthesizer.throwException(b, targetField, throwNoClassDefFoundErrorMethod);
    }

    public static void throwNoSuchFieldError(GraphBuilderContext b, String targetField) {
        ExceptionSynthesizer.throwException(b, targetField, throwNoSuchFieldErrorMethod);
    }

    public static void throwNoSuchMethodError(GraphBuilderContext b, String targetMethod) {
        ExceptionSynthesizer.throwException(b, targetMethod, throwNoSuchMethodErrorMethod);
    }

    private static void throwException(GraphBuilderContext b, String message, Method reportExceptionMethod) {
        ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(message), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
        ResolvedJavaMethod exceptionMethod = b.getMetaAccess().lookupJavaMethod((Executable)reportExceptionMethod);
        assert (exceptionMethod.isStatic());
        b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, exceptionMethod, new ValueNode[]{messageNode}, false);
        b.append((ValueNode)new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.UnreachedCode));
    }

    static {
        try {
            throwClassNotFoundExceptionMethod = ImplicitExceptions.class.getDeclaredMethod("throwClassNotFoundException", String.class);
            throwNoSuchFieldExceptionMethod = ImplicitExceptions.class.getDeclaredMethod("throwNoSuchFieldException", String.class);
            throwNoSuchMethodExceptionMethod = ImplicitExceptions.class.getDeclaredMethod("throwNoSuchMethodException", String.class);
            throwNoClassDefFoundErrorMethod = ImplicitExceptions.class.getDeclaredMethod("throwNoClassDefFoundError", String.class);
            throwNoSuchFieldErrorMethod = ImplicitExceptions.class.getDeclaredMethod("throwNoSuchFieldError", String.class);
            throwNoSuchMethodErrorMethod = ImplicitExceptions.class.getDeclaredMethod("throwNoSuchMethodError", String.class);
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

