/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOfNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@Platforms(value={Platform.AMD64.class})
class AMD64ArrayIndexOfForeignCalls {
    private static final ForeignCallDescriptor[] ORIGINAL_FOREIGN_CALLS = new ForeignCallDescriptor[]{AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_1_BYTE, AMD64ArrayIndexOf.STUB_INDEX_OF_2_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_3_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_4_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR, AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS};
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = (SnippetRuntime.SubstrateForeignCallDescriptor[])Arrays.stream(ORIGINAL_FOREIGN_CALLS).map(call -> SnippetRuntime.findForeignCall(AMD64ArrayIndexOfForeignCalls.class, call.getName(), true, new LocationIdentity[0])).toArray(SnippetRuntime.SubstrateForeignCallDescriptor[]::new);

    AMD64ArrayIndexOfForeignCalls() {
    }

    @SubstrateForeignCallTarget
    private static int indexOfTwoConsecutiveBytes(Pointer arrayPointer, int arrayLength, int searchValue) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (boolean)true, (Pointer)arrayPointer, (int)arrayLength, (int)searchValue);
    }

    @SubstrateForeignCallTarget
    private static int indexOfTwoConsecutiveChars(Pointer arrayPointer, int arrayLength, int searchValue) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (boolean)true, (Pointer)arrayPointer, (int)arrayLength, (int)searchValue);
    }

    @SubstrateForeignCallTarget
    private static int indexOf1Byte(Pointer arrayPointer, int arrayLength, byte b) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (Pointer)arrayPointer, (int)arrayLength, (byte)b);
    }

    @SubstrateForeignCallTarget
    private static int indexOf2Bytes(Pointer arrayPointer, int arrayLength, byte b1, byte b2) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (Pointer)arrayPointer, (int)arrayLength, (byte)b1, (byte)b2);
    }

    @SubstrateForeignCallTarget
    private static int indexOf3Bytes(Pointer arrayPointer, int arrayLength, byte b1, byte b2, byte b3) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (Pointer)arrayPointer, (int)arrayLength, (byte)b1, (byte)b2, (byte)b3);
    }

    @SubstrateForeignCallTarget
    private static int indexOf4Bytes(Pointer arrayPointer, int arrayLength, byte b1, byte b2, byte b3, byte b4) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (Pointer)arrayPointer, (int)arrayLength, (byte)b1, (byte)b2, (byte)b3, (byte)b4);
    }

    @SubstrateForeignCallTarget
    private static int indexOf1Char(Pointer arrayPointer, int arrayLength, char c) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (Pointer)arrayPointer, (int)arrayLength, (char)c);
    }

    @SubstrateForeignCallTarget
    private static int indexOf2Chars(Pointer arrayPointer, int arrayLength, char c1, char c2) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (Pointer)arrayPointer, (int)arrayLength, (char)c1, (char)c2);
    }

    @SubstrateForeignCallTarget
    private static int indexOf3Chars(Pointer arrayPointer, int arrayLength, char c1, char c2, char c3) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (Pointer)arrayPointer, (int)arrayLength, (char)c1, (char)c2, (char)c3);
    }

    @SubstrateForeignCallTarget
    private static int indexOf4Chars(Pointer arrayPointer, int arrayLength, char c1, char c2, char c3, char c4) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (Pointer)arrayPointer, (int)arrayLength, (char)c1, (char)c2, (char)c3, (char)c4);
    }
}

